% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrpart.h.R
\name{corrPart}
\alias{corrPart}
\title{Partial Correlation}
\usage{
corrPart(data, vars, controls, pearson = TRUE, spearman = FALSE,
  kendall = FALSE, type = "part", sig = TRUE, flag = FALSE,
  n = FALSE, hypothesis = "corr")
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming the variables to correlate in
\code{data}}

\item{controls}{a vector of strings naming the control variables in
\code{data}}

\item{pearson}{\code{TRUE} (default) or \code{FALSE}, provide Pearson's R}

\item{spearman}{\code{TRUE} or \code{FALSE} (default), provide Spearman's
rho}

\item{kendall}{\code{TRUE} or \code{FALSE} (default), provide Kendall's
tau-b}

\item{type}{one of \code{'part'} (default) or \code{'semi'} specifying the
type of partial correlation to calculate; partial or semipartial
correlation.}

\item{sig}{\code{TRUE} (default) or \code{FALSE}, provide significance
levels}

\item{flag}{\code{TRUE} or \code{FALSE} (default), flag significant
correlations}

\item{n}{\code{TRUE} or \code{FALSE} (default), provide the number of cases}

\item{hypothesis}{one of \code{'corr'} (default), \code{'pos'},
\code{'neg'} specifying the alernative hypothesis; correlated, correlated
positively, correlated negatively respectively.}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$matrix} \tab \tab \tab \tab \tab a (semi)partial correlation matrix table \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$matrix$asDF}

\code{as.data.frame(results$matrix)}
}
\description{
Partial correlation matrices are a way to examine linear relationships
between two or more continuous variables while controlling for other
variables
}
\details{
For each pair of variables, a Pearson's r value indicates the strength
and direction of the relationship between those two variables. A
positive value indicates a positive relationship (higher values of one
variable predict higher values of the other variable). A negative
Pearson's r indicates a negative relationship (higher values of one
variable predict lower values of the other variable, and vice-versa).
A value of zero indicates no relationship (whether a variable is high
or low, does not tell us anything about the value of the other
variable).

More formally, it is possible to test the null hypothesis that the
correlation is zero and calculate a p-value. If the p-value is low, it
suggests the correlation co-efficient is not zero, and there is a linear
(or more complex) relationship between the two variables.
}
\examples{
\donttest{
data('mtcars')

corrPart(mtcars, vars = vars(mpg, cyl, disp), controls = vars(hp))

#
#  PARTIAL CORRELATION
#
#  Partial Correlation
#  ----------------------------------------------------
#                           mpg       cyl       disp
#  ----------------------------------------------------
#    mpg     Pearson's r         —
#            p-value             —
#
#    cyl     Pearson's r    -0.590         —
#            p-value        < .001         —
#
#    disp    Pearson's r    -0.606     0.719        —
#            p-value        < .001    < .001        —
#  ----------------------------------------------------
#    Note. controlling for 'hp'
#
}
}
