% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box.R
\name{boxUI}
\alias{boxUI}
\title{boxUI: shiny module UI for boxplot}
\usage{
boxUI(id, label = "boxplot")
}
\arguments{
\item{id}{id}

\item{label}{label}
}
\value{
Shiny module UI for boxplot
}
\description{
Shiny module UI for boxplot
}
\details{
Shiny module UI for boxplot
}
\examples{
library(shiny)
library(ggplot2)
library(ggpubr)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      boxUI("box")
    ),
    mainPanel(
      optionUI("box"),
      plotOutput("box_plot"),
      ggplotdownUI("box")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_box <- boxServer("box",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$box_plot <- renderPlot({
    print(out_box())
  })
}
}
