% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaplan_meier.R
\name{kaplan_meier}
\alias{kaplan_meier}
\alias{a_kaplan_meier}
\alias{s_kaplan_meier}
\title{Survival time analysis}
\usage{
a_kaplan_meier(
  df,
  .var,
  ...,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_kaplan_meier(df, .var, is_event, control = control_surv_time())
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{...}{additional arguments for the lower level functions.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{'auto'} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{is_event}{(\code{character})\cr variable name storing Logical values: \code{TRUE} if event,
\code{FALSE} if time to event is censored.}

\item{control}{(\code{list})\cr parameters for comparison details, specified by using the helper function
\code{\link[tern:control_surv_time]{tern::control_surv_time()}}. Some possible parameter options are:
\itemize{
\item \code{conf_level} (\code{proportion})\cr confidence level of the interval for survival time.
\item \code{conf_type} (\code{string})\cr confidence interval type. Options are 'plain' (default), 'log', or 'log-log',
see more in \code{\link[survival:survfit]{survival::survfit()}}. Note option 'none' is not supported.
\item \code{quantiles} (\code{numeric})\cr vector of length two to specify the quantiles of survival time.
}}
}
\value{
\itemize{
\item \code{a_kaplan_meier()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{s_kaplan_meier()} returns the following statistics:
\itemize{
\item \code{quantiles_lower}: Lower quantile estimate and confidence interval for it.
\item \code{median_ci_3d}: Median survival time and confidence interval for it.
\item \code{quantiles_upper}: Upper quantile estimate and confidence interval for it.
\item \code{range_with_cens_info}: Survival time range with censoring information.
}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analyze function \code{\link[=kaplan_meier]{kaplan_meier()}} creates a layout element to analyze
survival time by calculating survival time median, 2 quantiles, each with
their confidence intervals, and range (for all, censored, or event patients).
The primary analysis variable \code{vars} is the time variable and the secondary
analysis variable \code{is_event} indicates whether or not an event has occurred.
}
\section{Functions}{
\itemize{
\item \code{a_kaplan_meier()}: Formatted analysis function which is used as \code{afun}

\item \code{s_kaplan_meier()}: Statistics function which analyzes survival times using Kaplan-Meier.

}}
\note{
These functions have been forked from the \code{tern} package file \code{survival_time.R}.
Here we have the additional features:
\itemize{
\item Additional statistics \code{quantiles_lower}, \code{quantiles_upper}, \code{range_with_cens_info} are returned.
}
}
\examples{
library(dplyr)
library(tern)
adtte_f <- tern::tern_ex_adtte |>
  filter(PARAMCD == "OS") |>
  mutate(
    AVAL = tern::day2month(AVAL),
    is_event = CNSR == 0
  )
df <- adtte_f |> filter(ARMCD == "ARM A")
a_kaplan_meier(
  df,
  .var = "AVAL",
  is_event = "is_event"
)

basic_table() |>
  split_cols_by(var = "ARMCD") |>
  add_colcounts() |>
  analyze(
    vars = "AVAL",
    afun = a_kaplan_meier,
    var_labels = "Kaplan-Meier estimate of time to event (months)",
    show_labels = "visible",
    extra_args = list(
      is_event = "is_event",
      control = control_surv_time(conf_level = 0.9, conf_type = "log-log")
    )
  ) |>
  build_table(df = adtte_f)

}
\keyword{internal}
