% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanjivec.R
\name{get_strokes}
\alias{get_strokes}
\title{Get the strokes of a kanjivec object}
\usage{
get_strokes(kvec, which = 1:kvec$nstrokes, simplify = TRUE)
}
\arguments{
\item{kvec}{an object of class \code{kanjivec}}

\item{which}{a numeric vector specifying the numbers of the strokes that are to be returned.
Defaults to all strokes.}

\item{simplify}{logical. Shall only the stroke be returned if \code{which} has length 1?}
}
\value{
Usually a list of strokes with attributes. Regardless of
whether \code{which} is ordered or contains duplicates, the returned list will always contain
the strokes in their natural order without duplicates. If \code{which} has length 1 and
\code{simplified = TRUE}, the list is avoided, and only the single stroke is returned.
}
\description{
The strokes are the leaves of the kanjivec \code{stroketree}. They consist of
a two-column matrix giving a discretized path for the stroke in the unit square \eqn{[0,1]^2}
with further attributes.
}
\examples{
kanji <- fivebetas[[5]]
get_strokes(kanji, c(3,10))    # the two long vertical strokes in \u9663

}
\seealso{
\code{\link{get_strokes_compo}}
}
