% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{predict.keras.engine.training.Model}
\alias{predict.keras.engine.training.Model}
\title{Generate predictions from a Keras model}
\usage{
\method{predict}{keras.engine.training.Model}(
  object,
  x,
  batch_size = NULL,
  verbose = "auto",
  steps = NULL,
  callbacks = NULL,
  ...
)
}
\arguments{
\item{object}{Keras model}

\item{x}{Input data (vector, matrix, or array). You can also
pass a \code{tfdataset} or a generator returning a list with \verb{(inputs, targets)} or
\verb{(inputs, targets, sample_weights)}.}

\item{batch_size}{Integer. If unspecified, it will default to 32.}

\item{verbose}{Verbosity mode, 0, 1, 2, or "auto". "auto" defaults to 1
for for most cases and defaults to \code{verbose=2} when used with
ParameterServerStrategy or with interactive logging disabled.}

\item{steps}{Total number of steps (batches of samples) before declaring the
evaluation round finished. Ignored with the default value of \code{NULL}.}

\item{callbacks}{List of callbacks to apply during prediction.}

\item{...}{Unused}
}
\value{
vector, matrix, or array of predictions
}
\description{
Generates output predictions for the input samples, processing the samples in
a batched way.
}
\seealso{
Other model functions: 
\code{\link{compile.keras.engine.training.Model}()},
\code{\link{evaluate.keras.engine.training.Model}()},
\code{\link{evaluate_generator}()},
\code{\link{fit.keras.engine.training.Model}()},
\code{\link{fit_generator}()},
\code{\link{get_config}()},
\code{\link{get_layer}()},
\code{\link{keras_model}()},
\code{\link{keras_model_sequential}()},
\code{\link{multi_gpu_model}()},
\code{\link{pop_layer}()},
\code{\link{predict_generator}()},
\code{\link{predict_on_batch}()},
\code{\link{predict_proba}()},
\code{\link{summary.keras.engine.training.Model}()},
\code{\link{train_on_batch}()}
}
\concept{model functions}
