% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run_app}
\alias{run_app}
\title{Run an App}
\usage{
run_app(
  app = c("diversity", "seriation", "aoristic", "mcd", "source", "scatter", "ternary",
    "ca", "pca"),
  bookmark = FALSE,
  options = list(launch.browser = interactive())
)
}
\arguments{
\item{app}{A \code{\link{character}} string specifying the \pkg{Shiny} application
to run (see details). Any unambiguous substring can be given.}

\item{bookmark}{A \code{\link{logical}} scalar: should server-side bookmarking of the
application be enabled (see \code{\link[shiny:enableBookmarking]{shiny::enableBookmarking()}})?}

\item{options}{A \code{\link{list}} of named options that should be passed to the
\code{\link[shiny:shinyApp]{shiny::shinyAppDir()}} call.}
}
\value{
A \pkg{shiny} application object.
}
\description{
A wrapper for \code{\link[shiny:shinyApp]{shiny::shinyAppDir()}}.
}
\details{
\tabular{ll}{
\strong{Application name}          \tab  \strong{Keyword} \cr
Aoristic Analysis             \tab \code{aoristic}   \cr
Correspondence Analysis       \tab \code{ca}         \cr
Principal Components Analysis \tab \code{pca}        \cr
Diversity Measures            \tab \code{diversity}  \cr
Mean Ceramic Date             \tab \code{mcd}        \cr
Scatter Plot                  \tab \code{scatter}    \cr
Matrix Seriation              \tab \code{seriation}  \cr
Compositional Data Analysis   \tab \code{source}     \cr
Ternary Plot                  \tab \code{ternary}    \cr
}
}
\examples{
if (interactive()) {
 run_app("seriation")
}
}
\author{
N. Frerebeau
}
\concept{shiny apps}
