% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmunionclosure.R
\name{kmunionclosure}
\alias{kmunionclosure}
\title{Close a family of sets under union}
\usage{
kmunionclosure(x)
}
\arguments{
\item{x}{Binary matrix representing a family of sets}
}
\value{
Binary matrix representing the corresponding knowledge space, i.e. the
closure of the family under union including the empty set and
the full set.

\code{kmunionclosure} implements the irredundant algorithm developed by Dowling (1993).
}
\description{
\code{kmunionclosure} returns a matrix representing a knowledge space. Please note
that it may take quite some time for computing larger knowledge spaces.
}
\examples{
kmunionclosure(xpl$basis)

}
\references{
Dowling, C. E. (1993). On the irredundant construction of knowledge spaces.
\emph{Journal of Mathematical Psychology, 37,} 49–62.
}
\seealso{
Other Different representations for knowledge spaces: 
\code{\link{kmSR2basis}()},
\code{\link{kmbasis.kmsurmisefunction}()},
\code{\link{kmbasis.kmsurmiserelation}()},
\code{\link{kmbasis.matrix}()},
\code{\link{kmsf2basis}()},
\code{\link{kmsurmisefunction}()},
\code{\link{kmsurmiserelation}()}
}
\concept{Different representations for knowledge spaces}
