% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_feature_cs.R
\name{create_feature_cs}
\alias{create_feature_cs}
\title{Create a Landscape Feature cost surface}
\usage{
create_feature_cs(raster, locations, x, neighbours = 16)
}
\arguments{
\item{raster}{\code{RasterLayer} (raster package). The Resolution, Extent, and Spatial Reference System of the provided RasterLayer is used when creating the resultant Barrier Cost Surface}

\item{locations}{\code{SpatialPoints*} (sp package). Location of Features within the landscape}

\item{x}{\code{numeric vector}. Values denoting the attraction/repulsion of the landscape features within the landscape. Each value in the vector is assigned to each ring of cells moving outwards from supplied locations}

\item{neighbours}{\code{numeric} value. Number of directions used in the Least Cost Path calculation. See Huber and Church (1985) for methodological considerations when choosing number of neighbours. Expected numeric values are 4, 8, 16, 32, 48 or a matrix object. Default is numeric value 16}
}
\value{
\code{TransitionLayer} (gdistance package) numerically expressing the attraction/repulsion of a feature in the landscape. The resultant \code{TransitionLayer} can be incorporated with other \code{TransitionLayer} through Raster calculations.
}
\description{
Creates a Landscape Feature Cost Surface representing the attraction/repulsion of a feature in the landscape. See Llobera (2000) for theoretical discussion in its application
}
\examples{
r <- raster::raster(system.file('external/maungawhau.grd', package = 'gdistance'))
loc1 = cbind(2667670, 6479000)
loc1 = sp::SpatialPoints(loc1)

num <- seq(200, 1, length.out = 20)

feature <- create_feature_cs(raster = r, locations = loc1, x = num)
}
\references{
Llobera, M. (2000). Understanding movement: a pilot model towards the sociology of movement. In: Lock G (ed) Beyond the map. Archaeology and spatial technologies. (pp 66-84). Amsterdam: IOS Press/Ohmsha.
}
\author{
Joseph Lewis
}
