% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turf.R
\name{turf_union}
\alias{turf_union}
\title{Union geometries}
\usage{
turf_union(map, layer_id = NULL, data = NULL, source_id, input_id = NULL)
}
\arguments{
\item{map}{A mapboxgl, maplibre, mapboxgl_proxy, or maplibre_proxy object.}

\item{layer_id}{The ID of a layer or source to union (mutually exclusive with data).}

\item{data}{An sf object to union (mutually exclusive with layer_id).}

\item{source_id}{The ID for the new source containing the union result. Required.}

\item{input_id}{Optional. Character string specifying the Shiny input ID suffix for storing results. If NULL (default), no input is registered. For proxy operations, the result will be available as \code{input[[paste0(map_id, "_turf_", input_id)]]}.}
}
\value{
The map or proxy object for method chaining.
}
\description{
This function unions all polygons in a layer into a single geometry.
The result is added as a source to the map, which can then be styled using add_fill_layer(), etc.
}
