% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/watch.R
\name{mapviewWatcher}
\alias{mapviewWatcher}
\alias{startWatching}
\alias{stopWatching}
\title{Start and/or stop automagic mapviewing of spatial objects in your workspace.}
\usage{
mapviewWatcher(env = .GlobalEnv, ...)

startWatching(env = .GlobalEnv, ...)

stopWatching(env = .GlobalEnv, ...)
}
\arguments{
\item{env}{the environment that is being watched (default is \code{.GlobalEnv}).}

\item{...}{currently not used.}
}
\description{
Use these functions to enable automatic viewing of all spatial objects
currently available in \code{env}. \code{mapviewWatcher} uses
\link[later]{later} to set up a watcher function that continuously monitors
\code{env} for spatial objects and refreshes the viewer/browser in case
the list of spatial objects changes.
\cr
\cr
\code{startWatching} and \code{stopWatching} are convenience functions to
start and stop watching, respectively.
}
\details{
\code{mapviewWatcher} uses \code{\link{identical}} and hence
will redraw even if e.g. the attributes of a spatial object are changed only
slightly. By default \code{mapviewWatcher} watches the \code{.GlobalEnv} but
this can be changed to another environment. Whether watching is turned on is
controlled by \code{mapviewGetOption("watch")}. In order to enable watching it
needs to be set to \code{mapviewOptions(watch = TRUE)}
(default is \code{FALSE}) and the watcher needs to be initiated by calling
\code{mapviewWatcher()} once. To switch watching off it is sufficient to set
\code{mapviewOptions(watch = FALSE)}.
}
\section{Functions}{
\itemize{
\item \code{startWatching()}: start watching

\item \code{stopWatching()}: stop watching

}}
\examples{
  if (interactive()) {
    library(mapview)

    ## start the watcher
    mapview::startWatching()

    ## load some data and watch the automatic visualisation
    fran = mapview::franconia
    brew = mapview::breweries

    ## stop the watcher
    mapview::stopWatching()

    ## loading or removing things now will not trigger a view update
    rm(brew)
    trls = mapview::trails

    ## re-starting the viewer will re-draw whatever is currently available
    mapview::startWatching()

    ## watcher can also be stopped via mapviewOptions
    mapviewOptions(watch = FALSE)

    rm(trls)

  }

}
