% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{size}
\alias{size}
\alias{size.figure}
\title{Sizing rule (Method)}
\usage{
size(fig, n, rule, ...)

\method{size}{figure}(fig, n = 2, rule = "size", ...)
}
\arguments{
\item{fig}{The figure on which the rule is applied}

\item{n}{A number defining the dimension of the sizing. Default is 2.}

\item{rule}{Define the sizing rule. Default is to reduce the dimension. rule = "inv" forces to increase the dimension.}

\item{...}{Other arguments}
}
\value{
A figure of class figure with different size.x and size.y
}
\description{
Apply a resizing to a figure
}
\section{Methods (by class)}{
\itemize{
\item \code{size(figure)}: Resize a figure

}}
\examples{
# default square
draw(square())

# apply the default resizing to the default square
draw(size(square()))

# make the square bigger
draw(size(square(), rule = "inv"))
}
