% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latexMatrixOperations.R
\name{latexMatrixOperations}
\alias{latexMatrixOperations}
\alias{matsum}
\alias{matsum.latexMatrix}
\alias{+.latexMatrix}
\alias{matdiff}
\alias{matdiff.latexMatrix}
\alias{-.latexMatrix}
\alias{*.latexMatrix}
\alias{Dot}
\alias{matmult}
\alias{matmult.latexMatrix}
\alias{\%*\%.latexMatrix}
\alias{matpower}
\alias{matpower.latexMatrix}
\alias{^.latexMatrix}
\alias{inverse}
\alias{inverse.latexMatrix}
\alias{t.latexMatrix}
\alias{determinant.latexMatrix}
\alias{solve.latexMatrix}
\alias{kronecker,latexMatrix,latexMatrix-method}
\alias{\%X\%}
\title{Various Functions and Operators for \code{"latexMatrix"} Objects}
\usage{
matsum(A, ...)

\method{matsum}{latexMatrix}(A, ..., as.numeric = TRUE)

\method{+}{latexMatrix}(e1, e2)

matdiff(A, B, ...)

\method{matdiff}{latexMatrix}(A, B = NULL, as.numeric = TRUE, ...)

\method{-}{latexMatrix}(e1, e2)

\method{*}{latexMatrix}(e1, e2)

Dot(x, y, simplify = TRUE)

matmult(X, ...)

\method{matmult}{latexMatrix}(X, ..., simplify = TRUE, as.numeric = TRUE)

\method{\%*\%}{latexMatrix}(x, y)

matpower(X, power, ...)

\method{matpower}{latexMatrix}(X, power, simplify = TRUE, as.numeric = TRUE, ...)

\method{^}{latexMatrix}(e1, e2)

inverse(X, ...)

\method{inverse}{latexMatrix}(X, ..., as.numeric = TRUE, simplify = TRUE)

\method{t}{latexMatrix}(x)

\method{determinant}{latexMatrix}(x, logarithm, ...)

\method{solve}{latexMatrix}(
  a,
  b,
  simplify = FALSE,
  as.numeric = TRUE,
  frac = c("\\\\dfrac", "\\\\frac", "\\\\tfrac", "\\\\cfrac"),
  ...
)

\S4method{kronecker}{latexMatrix,latexMatrix}(X, Y, FUN = "*", make.dimnames = FALSE, ...)

x \%X\% y
}
\arguments{
\item{A}{a \code{"latexMatrix"} object}

\item{...}{for \code{matmult()} and \code{sum()} zero or more 
\code{"latexMatrix"} objects; otherwise arguments to be passed down}

\item{as.numeric}{if \code{TRUE} (the default) and the matrices to be multiplied, added, etc., can be
coerced to numeric, matrix multiplication, addition, etc., is performed numerically;
supersedes \code{simplify}}

\item{e1}{a \code{"latexMatrix"} object; or for \code{*} a scalar;}

\item{e2}{a \code{"latexMatrix"} object;  for \code{*} a scalar;
for \code{^} an integer power \code{>= -1} to raise a square matrix}

\item{B}{a \code{"latexMatrix"} object}

\item{x}{for \code{Dot} a numeric or character vector; 
otherwise a \code{"latexMatrix"} object}

\item{y}{for \code{Dot} a numeric or character vector; 
otherwise a \code{"latexMatrix"} object}

\item{simplify}{if \code{TRUE} (the default), an attempt is made
to simplify the result slightly; for \code{solve()}, 
return a LaTeX expression with the inverse of the determinant in
front of the adjoint matrix rather than a \code{"latexMatrix"} object in which each
element of the adjoint matrix is divided by the determinant}

\item{X}{a \code{"latexMatrix"} object}

\item{power}{to raise a square matrix to this power, an integer \code{>= -1}.}

\item{logarithm}{to match the generic \code{\link{determinant}()} function,
ignored}

\item{a}{a \code{"latexMatrix"} object representing a square matrix}

\item{b}{ignored; to match the \code{\link{solve}()} generic}

\item{frac}{LaTeX command to use in forming fractions; the default
is \code{"\\dfrac"}}

\item{Y}{a \code{"latexMatrix"} object}

\item{FUN}{to match the \code{\link{kronecker}()} generic, ignored}

\item{make.dimnames}{to match the \code{\link{kronecker}()} generic, ignored}
}
\value{
All of these functions return \code{"latexMatrix"} objects, 
except for \code{Dot()}, which returns a LaTeX expression as a character string.
}
\description{
These operators and functions provide for LaTeX representations of
symbolic and numeric matrix arithmetic and computations.
They provide reasonable means to compose meaningful matrix equations
in LaTeX far easier than doing this manually matrix by matrix.

The following operators and functions are documented here:
\itemize{
\item \code{matsum()} and \code{+}, matrix addition;
\item \code{matdiff()} and \code{-}, matrix subtraction and negation;
\item \code{*}, product of a scalar and a matrix;
\item \code{Dot()}, inner product of two vectors;
\item \code{matprod()} and \code{\%*\%}, matrix product;
\item \code{matpower()} and \code{^}, powers (including inverse) of 
a square matrix;
\item \code{solve()} and \code{inverse()}, matrix inverse of a square matrix;
\item \code{t()}, transpose;
\item \code{determinant()} of a square matrix;
\item \code{kronecker()} and \code{\%O\%}, the Kronecker product.
}
}
\details{
These operators and functions only apply to \code{"latexMatrix"} objects
of definite (i.e., numeric) dimensions. 

When there are both a \emph{function} and an
\emph{operator} (e.g., \code{matmult()} and \code{\%*\%}), the former is more
flexible via optional arguments and the latter calls the former with default 
arguments. For example, using the operator \code{A \%*\% B} multiplies 
the two matrices \code{A} and \code{B}, returning a symbolic result.
The function \code{matmult()} multiplies two \emph{or more} matrices, and
can simplify the result and/or produced the numeric representation of the
product.

The result of matrix multiplication, \eqn{\mathbf{C} = \mathbf{A} \: \mathbf{B}}
is composed of the vector inner (dot) products of each \emph{row} of \eqn{\mathbf{A}} with
each \emph{column} of \eqn{\mathbf{B}},
\deqn{c_{ij} = \mathbf{a}_i^\top \mathbf{b}_j 
             = \Sigma_k a_{ik} \cdot b_{kj}}

The \code{Dot()} function computes the inner product symbolically in LaTeX notation for
numeric and character vectors, simplifying the result if \code{simplify = TRUE.}
The LaTeX symbol for multiplication (\code{"\\cdot"} by default)
can be changed by changing \code{options(latexMultSymbol)},
e.g, \code{options(latexMultSymbol = "\\\\times")} (note the double-backslash).
}
\examples{
A <- latexMatrix(symbol="a", nrow=2, ncol=2)
B <- latexMatrix(symbol="b", nrow=2, ncol=2)
A
B
A + B
A - B
"a" * A
C <- latexMatrix(symbol="c", nrow=2, ncol=3)
A \%*\% C
t(C)
determinant(A)
cat(solve(A, simplify=TRUE))
D <- latexMatrix(matrix(letters[1:4], 2, 2))
D
as.numeric(D, locals=list(a=1, b=2, c=3, d=4))
X <- latexMatrix(matrix(c(3, 2, 0, 1, 1, 1, 2,-2, 1), 3, 3))
X
as.numeric(X)
MASS::fractions(as.numeric(inverse(X)))
(d <- determinant(X))
eval(parse(text=(gsub("\\\\\\\\cdot", "*", d))))
X <- latexMatrix(matrix(1:6, 2, 3), matrix="bmatrix")
I3 <- latexMatrix(diag(3))
I3 \%X\% X
kronecker(I3, X, sparse=TRUE)

(E <- latexMatrix(diag(1:3)))
# equivalent:
X \%*\% E
matmult(X, E)

matmult(X, E, simplify=FALSE, as.numeric=FALSE)

# equivalent:
X \%*\% E \%*\% E
matmult(X, E, E)

# equivalent:
E^-1
inverse(E)
solve(E)

solve(E, as.numeric=FALSE) # details

# equivalent
E^3
matpower(E, 3)

matpower(E, 3, as.numeric=FALSE)
}
\seealso{
\code{\link{latexMatrix}}
}
\author{
John Fox
}
