% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{SummaryLM-class}
\alias{SummaryLM-class}
\alias{SummaryLM}
\title{\linkS4class{SummaryLM} class}
\description{
S4 class for a summary of \linkS4class{LM} objects.
}
\section{Slots}{

\describe{
\item{\code{statistic}}{A single numeric for the minus twice the empirical
log-likelihood ratio for the overall test of the model.}

\item{\code{df}}{A single integer for the degrees of freedom of the statistic.}

\item{\code{convergence}}{A single logical for the convergence status of the
constrained minimization.}

\item{\code{sigTests}}{A numeric matrix of the results of significance tests.}

\item{\code{weighted}}{A single logical for whether the given model is weighted or
not.}

\item{\code{na.action}}{Information returned by \code{\link{model.frame}} on the special
handling of \code{NA}s.}

\item{\code{call}}{A matched call.}

\item{\code{terms}}{A \code{\link{terms}} object used.}

\item{\code{aliased}}{A named logical vector showing if the original coefficients are
aliased.}
}}

\examples{
showClass("SummaryLM")
}
