% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_glm.R
\name{el_glm}
\alias{el_glm}
\title{Empirical likelihood for generalized linear models}
\usage{
el_glm(
  formula,
  family = gaussian,
  data,
  weights = NULL,
  na.action,
  control = el_control(),
  start = NULL,
  etastart = NULL,
  mustart = NULL,
  ...
)
}
\arguments{
\item{formula}{An object of class \code{\link{formula}} (or one that can be coerced to
that class): a symbolic description of the model to be fitted.}

\item{family}{A description of the error distribution and link function to be
used in the model. Only the result of a call to a family function is
supported. See ‘Details’.}

\item{data}{An optional data frame, list or environment (or object coercible
by \code{\link[=as.data.frame]{as.data.frame()}} to a data frame) containing the variables in the
formula. If not found in data, the variables are taken from
\code{environment(formula)}.}

\item{weights}{An optional numeric vector of weights to be used in the
fitting process. Defaults to \code{NULL}, corresponding to identical weights. If
non-\code{NULL}, weighted empirical likelihood is computed.}

\item{na.action}{A function which indicates what should happen when the data
contain \code{NA}s. The default is set by the \code{na.action} setting of
\code{\link{options}}, and is \code{na.fail} if that is unset.}

\item{control}{An object of class \linkS4class{ControlEL} constructed by
\code{\link[=el_control]{el_control()}}.}

\item{start}{Starting values for the parameters in the linear predictor.
Defaults to \code{NULL} and is passed to \code{\link[=glm.fit]{glm.fit()}}.}

\item{etastart}{Starting values for the linear predictor. Defaults to \code{NULL}
and is passed to \code{\link[=glm.fit]{glm.fit()}}.}

\item{mustart}{Starting values for the vector of means. Defaults to \code{NULL}
and is passed to \code{\link[=glm.fit]{glm.fit()}}.}

\item{...}{Additional arguments to be passed to \code{\link[=glm.control]{glm.control()}}.}
}
\value{
An object of class of \linkS4class{GLM}.
}
\description{
Fits a generalized linear model with empirical likelihood.
}
\details{
The available families and link functions are as follows:
\itemize{
\item \code{gaussian}: \code{"identity"}, \code{"log"}, and \code{"inverse"}.
\item \code{bimomial}: \code{"logit"}, \code{"probit"}, and \code{"log"}.
\item \code{poisson}: \code{"log"}, \code{"identity"}, and \code{"sqrt"}.
\item \code{quasipoisson}: \code{"log"}.
}

Included in the tests are the overall test with
\deqn{H_0: \beta_1 = \beta_2 = \cdots = \beta_{p-1} = 0,}
and the tests for each parameter with
\deqn{H_{0j}: \beta_j = 0,\ j = 0, \dots, p-1.}
The test results are returned as \code{optim} and \code{sigTests}, respectively.
}
\examples{
set.seed(20010)
n <- 50
x <- rnorm(n)
x2 <- rnorm(n)
l <- -2 + 0.2 * x + 3 * x2
mu <- 1 / (1 + exp(-l))
y <- rbinom(n, 1, mu)
df <- data.frame(y, x, x2)
fit <- el_glm(y ~ x + x2,
  family = binomial, data = df, weights = NULL,
  na.action = na.omit, start = NULL, etastart = NULL, mustart = NULL
)
summary(fit)
}
\references{
Chen SX, Cui H (2003).
“An Extended Empirical Likelihood for Generalized Linear Models.”
Statistica Sinica, 13(1), 69–81.

Kolaczyk ED (1994).
“Empirical Likelihood for Generalized Linear Models.”
Statistica Sinica, 4(1), 199–218.
}
\seealso{
\code{\link[=el_control]{el_control()}}, \code{\link[=el_lm]{el_lm()}}, \code{\link[=elt]{elt()}}
}
