% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pVal-methods.R
\name{pVal}
\alias{pVal}
\alias{pVal,EL-method}
\alias{pVal,ELT-method}
\alias{pVal,ELMT-method}
\title{\eqn{p}-value}
\usage{
\S4method{pVal}{EL}(object, ...)

\S4method{pVal}{ELT}(object, ...)

\S4method{pVal}{ELMT}(object, ...)
}
\arguments{
\item{object}{An object that inherit from \linkS4class{EL},
\linkS4class{ELT}, or \linkS4class{ELMT}.}

\item{...}{Further arguments passed to methods.}
}
\value{
The form of the value returned by \code{\link[=pVal]{pVal()}} depends on the class of
its argument.
}
\description{
Extracts \eqn{p}-value from a model.
}
\section{Methods (by class)}{
\itemize{
\item \code{pVal(EL)}: Extracts the \eqn{p}-value.

\item \code{pVal(ELT)}: Extracts the \eqn{p}-value.

\item \code{pVal(ELMT)}: Extracts the multiplicity adjusted \eqn{p}-values.

}}
\examples{
data("precip")
fit <- el_mean(precip, par = 40)
pVal(fit)
}
\seealso{
\code{\link[=chisq]{chisq()}}
}
