% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGEtest.R
\name{metaGE.incidence}
\alias{metaGE.incidence}
\title{Create the matrix of incidence.}
\usage{
metaGE.incidence(VarName, Covariate, EnvName, Data, AtLeast = 1)
}
\arguments{
\item{VarName}{The name of the column containing the categorical variable in the Covariate dataset.}

\item{Covariate}{A dataset containing categorical variables (in columns) describing the environments (in rows).}

\item{EnvName}{The name of the column containing the names of the environment in the Covariate dataset.}

\item{Data}{A dataset containing the effects and pvalues of each marker (in rows) in each environment (in columns), as obtained from metaGE.collect.}

\item{AtLeast}{A numeric value indicating the minimum number of environments must belong to each level (equals 1 by default).}
}
\value{
A  binary matrix containing indicator variables with in rows the levels of the variables and in columns the environment.
}
\description{
The function metaGE.incidence convert categorical variable describing the environments into a matrix of dummy variables with in rows the levels of the variables and in columns the environment.
}
\details{
The names of the environment must be the same as used in the Data dataset.
}
\examples{
# Import the data
data("metaData")
data("envDesc")

# Build the matrix of incidence
(Incidence.Temp <- metaGE.incidence(VarName = "Temp",Covariate = envDesc,
                                    EnvName = "ShortName", Data = metaData))
}
