% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solutions_matrix.R
\name{get_pvals}
\alias{get_pvals}
\title{Get p-values from an extended solutions matrix}
\usage{
get_pvals(
  extended_solutions_matrix,
  negative_log = FALSE,
  keep_summaries = TRUE
)
}
\arguments{
\item{extended_solutions_matrix}{The output of \code{extend_solutions}. A
dataframe that contains at least one p-value column ending in "_pval".}

\item{negative_log}{If TRUE, will replace p-values with negative log
p-values.}

\item{keep_summaries}{If FALSE, will remove the mean, min, and max p-value.}
}
\value{
A "data.frame" class object Of only the p-value related columns
of the provided extended_solutions_matrix.
}
\description{
This function can be used to neatly format the p-values associated with an
extended solutions matrix. It can also calculate the negative logs of those
p-values to make it easier to interpret large-scale differences.
}
