% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmaps.R
\name{settings_matrix_heatmap}
\alias{settings_matrix_heatmap}
\title{Heatmap for visualizing a settings matrix}
\usage{
settings_matrix_heatmap(
  settings_matrix,
  order = NULL,
  remove_fixed_columns = TRUE,
  show_column_names = TRUE,
  show_row_names = TRUE,
  rect_gp = grid::gpar(col = "black"),
  colour_breaks = c(0, 1),
  colours = c("black", "darkseagreen"),
  column_split_vector = NULL,
  row_split_vector = NULL,
  column_split = NULL,
  row_split = NULL,
  column_title = NULL,
  ...
)
}
\arguments{
\item{settings_matrix}{Matrix indicating parameters to iterate SNF through.}

\item{order}{Numeric vector indicating row ordering of settings matrix.}

\item{remove_fixed_columns}{Whether columns that have no variation should be
removed.}

\item{show_column_names}{Whether column names should be shown.}

\item{show_row_names}{Whether row names should be shown.}

\item{rect_gp}{Cell border function for \code{ComplexHeatmap::Heatmap}.}

\item{colour_breaks}{Numeric vector of breaks for the legend.}

\item{colours}{Vector of colours to use for the heatmap. Should match the
length of colour_breaks.}

\item{column_split_vector}{Vector of indices to split columns by.}

\item{row_split_vector}{Vector of indices to split rows by.}

\item{column_split}{Standard parameter of \code{ComplexHeatmap::Heatmap}.}

\item{row_split}{Standard parameter of \code{ComplexHeatmap::Heatmap}.}

\item{column_title}{Standard parameter of \code{ComplexHeatmap::Heatmap}.}

\item{...}{Additional parameters passed to \code{ComplexHeatmap::Heatmap}.}
}
\value{
Returns a heatmap (class "Heatmap" from package ComplexHeatmap)
that displays the scaled values of the provided settings matrix.
}
\description{
Scales settings matrix values between 0 and 1 and plots as a heatmap. Rows
can be reordered to match prior meta clustering results.
}
