% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{km}
\alias{km}
\title{Kaplan-Meier with robust standard errors}
\usage{
km(formula, data = data, ...)
}
\arguments{
\item{formula}{formula with 'Surv' 'Event' outcome}

\item{data}{data frame}

\item{...}{Additional arguments to phreg}
}
\description{
Kaplan-Meier with robust standard errors 
Robust variance is default variance and obtained from the predict call
}
\examples{
library(mets)
data(sTRACE)
sTRACE$cluster <- sample(1:100,500,replace=TRUE)
out1 <- km(Surv(time,status==9)~strata(vf,chf),data=sTRACE)
out2 <- km(Surv(time,status==9)~strata(vf,chf)+cluster(cluster),data=sTRACE)

summary(out1,times=1:3)
summary(out2,times=1:3)

par(mfrow=c(1,2))
plot(out1,se=TRUE)
plot(out2,se=TRUE)
}
\author{
Thomas Scheike
}
