% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{weighted.mse}
\alias{weighted.mse}
\alias{weighted.rmse}
\alias{weighted.mae}
\alias{weighted.medae}
\title{Weighted Loss Functions}
\usage{
weighted.mse(x, y = NULL, w = NULL, ..., na.rm = FALSE)

weighted.rmse(x, y = NULL, w = NULL, ..., na.rm = FALSE)

weighted.mae(x, y = NULL, w = NULL, ..., na.rm = FALSE)

weighted.medae(x, y = NULL, w = NULL, ..., na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{an optional numeric vector. If passed, the loss is calculated for the differences between \code{x} and \code{y}. If not, the loss is calculated for the deviations of \code{x} from the weighted mean of itself.}

\item{w}{a numeric vector of sample weights for each value in \code{x}.}

\item{...}{optional parameters.}

\item{na.rm}{logical. If \code{TRUE}, any \code{NA} and \code{NaN}s are removed from \code{x} before the calculation.}
}
\value{
\code{weighted.mse()} (mean square error), \code{weighted.rmse()} (root mean square error), \code{weighted.mae()} (mean absolute error) and \code{weighted.medae} (median absolute error) returns a single numeric value.
}
\description{
\code{weighted.mse()}, \code{weighted.rmse()}, \code{weighted.mae()} and \code{weighted.medae()} compute the loss based on the differences of two numeric vectors or deviations from the mean of a numeric vector.
}
\details{
\code{weighted.mse()} returns the mean square error, \code{weighted.rmse()} returns the root mean square error, \code{weighted.mae()} returns the mean absolute error, and \code{weighted.medae()} returns the median absolute error between two weighted vectors \code{x} and \code{y}. If \code{y} is not passed, these functions return the corresponding statistic based on the deviations from the mean of \code{x}.
}
\examples{
weighted.rmse(x = c(0, 10), y = c(0, 0), w = c(99, 1))
weighted.mae(x = c(0, 10), y = c(0, 0), w = c(99, 1))
weighted.medae(x = c(0, 10), y = c(0, 0), w = c(99, 1))
# compute uninterpreted rate
mid <- interpret(dist ~ speed, cars)
weighted.mse(cars$dist, predict(mid, cars)) / weighted.mse(cars$dist)
mid$ratio
}
