% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_diffusion.R
\name{make_play}
\alias{make_play}
\alias{play_diffusions}
\title{Simulating multiple diffusion processes}
\usage{
play_diffusions(
  .data,
  ...,
  times = 5,
  strategy = "sequential",
  verbose = FALSE
)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{...}{Other parameters inherited from \code{manynet::play_diffusion()}.}

\item{times}{Integer indicating number of simulations.
By default \code{times=5}, but 1,000 - 10,000 simulations recommended for publication-ready results.}

\item{strategy}{If \code{{furrr}} is installed, then multiple cores can be used to accelerate the simulations.
By default "sequential", but if multiple cores available, then "multisession" or "multicore" may be useful.
Generally this is useful only when times > 1000. See \code{{furrr}} for more.}

\item{verbose}{Whether the function should report on its progress.
By default FALSE. See \code{{progressr}} for more.}
}
\description{
Simulating multiple diffusion processes
}
\examples{
# plot(play_diffusions(smeg, times = 10))
}
