% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_misvm.R
\name{predict.cv_misvm}
\alias{predict.cv_misvm}
\title{Predict method for \code{cv_misvm} object}
\usage{
\method{predict}{cv_misvm}(
  object,
  new_data,
  type = c("class", "raw"),
  layer = c("bag", "instance"),
  new_bags = "bag_name",
  ...
)
}
\arguments{
\item{object}{An object of class \code{cv_misvm}.}

\item{new_data}{A data frame to predict from. This needs to have all of the
features that the data was originally fitted with.}

\item{type}{If \code{'class'}, return predicted values with threshold of 0 as
-1 or +1.  If \code{'raw'}, return the raw predicted scores.}

\item{layer}{If \code{'bag'}, return predictions at the bag level.  If
\code{'instance'}, return predictions at the instance level.}

\item{new_bags}{A character or character vector.  Can specify a singular
character that provides the column name for the bag names in \code{new_data}
(default \code{'bag_name'}).  Can also specify a vector of length
\code{nrow(new_data)} that has bag name for each row.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A tibble with \code{nrow(new_data)} rows.  If \code{type = 'class'}, the tibble
will have a column '.pred_class'.  If \code{type = 'raw'}, the tibble will have
a column '.pred'.
}
\description{
Predict method for \code{cv_misvm} object
}
\examples{
mil_data <- generate_mild_df(
  nbag = 10,
  nsample = 20,
  positive_degree = 3
)
df1 <- build_instance_feature(mil_data, seq(0.05, 0.95, length.out = 10))
mdl1 <- cv_misvm(x = df1[, 4:123], y = df1$bag_label,
                 bags = df1$bag_name, cost_seq = 2^(-2:2),
                 n_fold = 3, method = "heuristic")

predict(mdl1, new_data = df1, type = "raw", layer = "bag")

# summarize predictions at the bag layer
suppressWarnings(library(dplyr))
df1 \%>\%
  bind_cols(predict(mdl1, df1, type = "class")) \%>\%
  bind_cols(predict(mdl1, df1, type = "raw")) \%>\%
  distinct(bag_name, bag_label, .pred_class, .pred)

}
\author{
Sean Kent
}
