% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{initialize_values}
\alias{initialize_values}
\title{Initialize Particle Swarm Optimization and Nelder-Mead Algorithm Values}
\usage{
initialize_values(init_swarm = NULL, init_local = NULL, init_coef_mat = NULL)
}
\arguments{
\item{init_swarm}{Optional matrix of initial particle positions. If not defined, particle positions are randomly generated using \code{runif} with pre-determined number of particles \code{n_swarm} and particle size.}

\item{init_local}{Optional vector of initial locally optimal design. If not defined, the initial vector representing locally optimal design is \code{c(1, 0.6, 0.3)}.}

\item{init_coef_mat}{Optional matrix of initial parameters to implement multi-start Nelder-Mead algorithm. The number of rows is the number of starts, and each row is the corresponding initial parameters. If not defined, the initial matrix of parameters is generated by sigmoid transformation of \code{10 * as.matrix(expand.grid(rep(list(c(1, -1)), j_factor + 1)))}.}
}
\value{
A list of initialized values.
}
\description{
Sets initial particles for PSO, initial locally optimal design, and initial parameters for Nelder-Mead algorithm.
}
\examples{
init_local <- c(1, 0.6, 0.3)

init_coef_mat <- rbind(
  c(1e-6, 0.99),
  c(1e-2, 1),
  c(1.01e-6, 0.9999))
  
j_factor <- 1
k_levels <- 3
n_swarm <- 32
d_swarm <- (j_factor + 1) * k_levels - 1
init_swarm <- matrix(runif(n_swarm*d_swarm), nrow=n_swarm, byrow=TRUE)

init_values <- initialize_values(init_swarm=init_swarm, 
                                  init_local=init_local, 
                                  init_coef_mat=init_coef_mat)

}
