% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orphanReactants.R
\name{orphanReactants}
\alias{orphanReactants}
\title{Identify the orphan reactants of a set of stoichometric reactions}
\usage{
orphanReactants(reactionList, byCompartment = FALSE)
}
\arguments{
\item{reactionList}{A set of stoichiometric reaction with the following format: 

\code{"H2O[c] + Urea-1-carboxylate[c] <=> 2 CO2[c] + 2 NH3[c]"} 

Where arrows and plus signs are surrounded by a "space character".
It is also expected that stoichiometry coefficients are surrounded by spaces, (nothe the "2" before the CO2[c] or the NH3[c]).
It also expects arrows to be in the form "\code{=>}" or "\code{<=>}". 
Meaning that arrows like "\code{==>}", "\code{<==>}", "\code{-->}" or "\code{->}" will not be parsed and will lead to errors.}

\item{byCompartment}{A boolean value \code{'TRUE'} or \code{'FALSE'} to indicate if orphan reactants should be reported by compartment}
}
\value{
If \code{byCompartment == FALSE}, a vector with orphan reactants is returned, in opposite case a list is returned.
}
\description{
This function identifies the orphan reactants (metabolites not produced in any other reaction or just are involved in one reaction) for a set of stoichometric reactions.
}
\examples{
# Loading data
glycolysis <- read.csv2(system.file("extdata", "glycolysisKEGG.csv", package = "minval"))
# Removing stoichiometric reactions without valid syntax
glycolysis <- mapReactions(
reactionList = isValidSyntax(glycolysis$REACTION),
referenceData = glycolysis,
by = "bool"
)

# Extracting orphan reactants
orphanReactants(reactionList = glycolysis$REACTION, byCompartment = FALSE)

# Extracting orphan by compartment
orphanReactants(reactionList = glycolysis$REACTION, byCompartment = TRUE)
}
\author{
Daniel Camilo Osorio <dcosorioh@unal.edu.co>
}

