% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{gpartition}
\alias{gpartition}
\title{Partitions the values of track expression}
\usage{
gpartition(
  expr = NULL,
  breaks = NULL,
  intervals = NULL,
  include.lowest = FALSE,
  iterator = NULL,
  band = NULL,
  intervals.set.out = NULL
)
}
\arguments{
\item{expr}{track expression}

\item{breaks}{breaks that determine the bin}

\item{intervals}{genomic scope for which the function is applied}

\item{include.lowest}{if 'TRUE', the lowest value of the range determined by
breaks is included}

\item{iterator}{track expression iterator. If 'NULL' iterator is determined
implicitly based on track expression.}

\item{band}{track expression band. If 'NULL' no band is used.}

\item{intervals.set.out}{intervals set name where the function result is
optionally outputted}
}
\value{
If 'intervals.set.out' is 'NULL' a set of intervals with an
additional column that indicates the corresponding bin index.
}
\description{
Converts the values of track expression to intervals that match
corresponding bin.
}
\details{
This function converts first the values of track expression into 1-based
bin's index according 'breaks' argument. It returns then the intervals with
the corresponding bin's index.

The range of bins is determined by 'breaks' argument. For example:
'breaks=c(x1, x2, x3, x4)' represents three different intervals (bins): (x1,
x2], (x2, x3], (x3, x4].

If 'include.lowest' is 'TRUE' the the lowest value will be included in the
first interval, i.e. in [x1, x2].

If 'intervals.set.out' is not 'NULL' the result is saved as an intervals
set. Use this parameter if the result size exceeds the limits of the
physical memory.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
breaks <- seq(0, 0.2, by = 0.05)
gpartition("dense_track", breaks, gintervals(1, 0, 5000))

}
\seealso{
\code{\link{gscreen}}, \code{\link{gextract}},
\code{\link{glookup}}, \code{\link{gdist}}
}
\keyword{~partition}
