% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_inner_fselect_archives.R
\name{extract_inner_fselect_archives}
\alias{extract_inner_fselect_archives}
\title{Extract Inner Feature Selection Archives}
\usage{
extract_inner_fselect_archives(x, exclude_columns = "uhash")
}
\arguments{
\item{x}{(\link[mlr3:ResampleResult]{mlr3::ResampleResult} | \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}).}

\item{exclude_columns}{(\code{character()})\cr
Exclude columns from result table. Set to \code{NULL} if no column should be
excluded.}
}
\value{
\code{\link[data.table:data.table]{data.table::data.table()}}.
}
\description{
Extract inner feature selection archives of nested resampling.
Implemented for \link[mlr3:ResampleResult]{mlr3::ResampleResult} and \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}.
The function iterates over the \link{AutoFSelector} objects and binds the archives to a \code{\link[data.table:data.table]{data.table::data.table()}}.
\link{AutoFSelector} must be initialized with \code{store_fselect_instance = TRUE} and \code{resample()} or \code{benchmark()} must be called with \code{store_models = TRUE}.
}
\section{Data structure}{


The returned data table has the following columns:
\itemize{
\item \code{experiment} (integer(1))\cr
Index, giving the according row number in the original benchmark grid.
\item \code{iteration} (integer(1))\cr
Iteration of the outer resampling.
\item One column for each feature of the task.
\item One column for each performance measure.
\item \code{runtime_learners} (\code{numeric(1)})\cr
Sum of training and predict times logged in learners per
\link[mlr3:ResampleResult]{mlr3::ResampleResult} / evaluation. This does not include potential
overhead time.
\item \code{timestamp} (\code{POSIXct})\cr
Time stamp when the evaluation was logged into the archive.
\item \code{batch_nr} (\code{integer(1)})\cr
Feature sets are evaluated in batches. Each batch has a unique batch
number.
\item \code{resample_result} (\link[mlr3:ResampleResult]{mlr3::ResampleResult})\cr
Resample result of the inner resampling.
\item \code{task_id} (\code{character(1)}).
\item \code{learner_id} (\code{character(1)}).
\item \code{resampling_id} (\code{character(1)}).
}
}

\examples{
# Nested Resampling on Palmer Penguins Data Set

# create auto fselector
at = auto_fselector(
  fselector = fs("random_search"),
  learner = lrn("classif.rpart"),
  resampling = rsmp ("holdout"),
  measure = msr("classif.ce"),
  term_evals = 4)

resampling_outer = rsmp("cv", folds = 2)
rr = resample(tsk("penguins"), at, resampling_outer, store_models = TRUE)

# extract inner archives
extract_inner_fselect_archives(rr)
}
