% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encapsulate.R
\name{encapsulate}
\alias{encapsulate}
\title{Encapsulate Function Calls for Logging}
\usage{
encapsulate(
  method,
  .f,
  .args = list(),
  .opts = list(),
  .pkgs = character(),
  .seed = NA_integer_,
  .timeout = Inf,
  .compute = "default"
)
}
\arguments{
\item{method}{(\code{character(1)})\cr
One of \code{"none"}, \code{"try"}, \code{"evaluate"}, \code{"callr"}, or \code{"mirai"}.}

\item{.f}{(\verb{function()})\cr
Function to call.}

\item{.args}{(\code{list()})\cr
Arguments passed to \code{.f}.}

\item{.opts}{(named \code{list()})\cr
Options to set for the function call. Options get reset on exit.}

\item{.pkgs}{(\code{character()})\cr
Packages to load (not attach).}

\item{.seed}{(\code{integer(1)})\cr
Random seed to set before invoking the function call.
Gets reset to the previous seed on exit.}

\item{.timeout}{(\code{numeric(1)})\cr
Timeout in seconds. Uses \code{\link[=setTimeLimit]{setTimeLimit()}} for \code{"none"} and \code{"evaluate"} encapsulation.
For \code{"callr"} encapsulation, the timeout is passed to \code{callr::r()}.
For \code{"mirai"} encapsulation, the timeout is passed to \code{mirai::mirai()}.}

\item{.compute}{(\code{character(1)})\cr
If \code{method} is \code{"mirai"}, a daemon with the specified compute profile is used or started.}
}
\value{
(named \code{list()}) with three fields:
\itemize{
\item \code{"result"}: the return value of \code{.f}
\item \code{"elapsed"}: elapsed time in seconds. Measured as \code{\link[=proc.time]{proc.time()}} difference before/after the function call.
\item \code{"log"}: \code{data.table()} with columns \code{"class"} (ordered factor with levels \code{"output"}, \code{"warning"} and \code{"error"}) and \code{"message"} (\code{character()}).
}
}
\description{
Evaluates a function while both recording an output log and measuring the elapsed time.
There are currently three different modes implemented to encapsulate a function call:
\itemize{
\item \code{"none"}: Just runs the call in the current session and measures the elapsed time.
Does not keep a log, output is printed directly to the console.
Works well together with \code{\link[=traceback]{traceback()}}.
\item \code{"try"}: Similar to \code{"none"}, but catches error. Output is printed to the console and
not logged.
\item \code{"evaluate"}: Uses the package \CRANpkg{evaluate} to call the function, measure time and do the logging.
\item \code{"callr"}: Uses the package \CRANpkg{callr} to call the function, measure time and do the logging.
This encapsulation spawns a separate R session in which the function is called.
While this comes with a considerable overhead, it also guards your session from being teared down by segfaults.
\item \code{"mirai"}: Uses the package \CRANpkg{mirai} to call the function, measure time and do the logging.
This encapsulation calls the function in a \code{mirai} on a \code{daemon}.
The \code{daemon} can be pre-started via \code{daemons(1)}.
All encapsulated function calls are executed in this \code{daemon}.
Using mirai is similarly safe as callr but much faster if several function calls are encapsulated one after the other on the same daemon.
}
}
\examples{
f = function(n) {
  message("hi from f")
  if (n > 5) {
    stop("n must be <= 5")
  }
  runif(n)
}

encapsulate("none", f, list(n = 1), .seed = 1)

if (requireNamespace("evaluate", quietly = TRUE)) {
  encapsulate("evaluate", f, list(n = 1), .seed = 1)
}

if (requireNamespace("callr", quietly = TRUE)) {
  encapsulate("callr", f, list(n = 1), .seed = 1)
}
}
