% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measurement_invariance.R
\name{measurement_invariance_models}
\alias{measurement_invariance_models}
\title{Measurement Invariance Models}
\usage{
measurement_invariance_models(
  cfa_out,
  max_free = 1,
  metric = TRUE,
  scalar = TRUE,
  progress = TRUE
)
}
\arguments{
\item{cfa_out}{The output of
\code{\link[lavaan:cfa]{lavaan::cfa()}}.}

\item{max_free}{The maximum number of
constraints to be released when
generating the partial invariance
models. For example, if set to 1,
then only the partial metric invariance
model only has at most one item allowed
to have different loadings across
group. Default is 1. If set to zero,
then no partial invariance models
will be generated.}

\item{metric}{Logical. If \code{TRUE},
the default, then metric invariance
model and its partial invariance
versions are generated.}

\item{scalar}{Logical. If \code{TRUE},
the default, then scalar invariance
model and its partial invariance
versions are generated.}

\item{progress}{Logical. If \code{TRUE},
the default, progress bars will be
displayed when fitting partial
invariance models.}
}
\value{
A list of \code{\link[lavaan:cfa]{lavaan::cfa()}}
output. The names are automatically
generated to indicate whether a model
is configural, metric, or scalar
invariance, or the item(s) without
between-group constraints on the
loadings (for partial metric
invariance) or intercepts (for
partial scalar invariance).
}
\description{
Generate metric and
scalar invariance models and their
partial invariance versions.
}
\details{
This a helper function to generate,
based on a multigroup confirmatory
factor analysis (CFA) model with
no between-group equality constraints,
the following models:
\itemize{
\item A metric invariance model (loadings
constrained to be equal across
groups).
\item A scalar invariance model (intercepts
and loadings constrained to be equal
across groups).
\item Partial invariance versions of the
previous two models, such as a
model with the loadings of all items,
except for one, constrained to be
equal across groups.
}

The models generated can then be used
in \code{model_set()} to compute BPPs.
\subsection{Requirements}{

The model used as the input needs to
be fitted with no between group
constrains, that is, it is a
configural invariance model. Although
not a must, it is advised to use
the default way to identify each
factor (that is, fixing a loading
to one).
}

\subsection{Implementation}{

This function simply use the
\code{group.partial} and \code{group.equal}
argument of \code{\link[lavaan:cfa]{lavaan::cfa()}} to
generate the models.
}
}
\examples{

library(lavaan)
# For illustration, only one factor is used,
# with one item from another factor added
# just to make the model not saturated.
HSmod <-
"
spatial =~ x1 + x2 + x3 + x4
"
fit_config <- cfa(model = HSmod,
                  data = HolzingerSwineford1939,
                  group = "school")
fit_mi <- measurement_invariance_models(fit_config)
names(fit_mi)
# Need to add 'skip_check_sem_out = TRUE' to use multigroup models.
out <- model_set(sem_out = fit_mi,
                 skip_check_sem_out = TRUE,
                 progress = FALSE,
                 parallel = FALSE)
print(out)

}
\seealso{
\code{\link[=model_set]{model_set()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
