% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIbeta.R
\name{CIbeta}
\alias{CIbeta}
\title{Confidence intervals for working (i.e., beta) parameters}
\usage{
CIbeta(m, alpha = 0.95)
}
\arguments{
\item{m}{A \code{momentuHMM} object}

\item{alpha}{Significance level of the confidence intervals. Default: 0.95 (i.e. 95\% CIs).}
}
\value{
A list of the following objects:
\item{...}{List(s) of estimates ('est'), standard errors ('se'), and confidence intervals ('lower', 'upper') for the working parameters of the data streams}
\item{beta}{List of estimates ('est'), standard errors ('se'), and confidence intervals ('lower', 'upper') for the working parameters of the transition probabilities}
}
\description{
Computes the standard errors and confidence intervals on the beta (i.e., working) scale of the data stream probability distribution parameters,
as well as for the transition probabilities regression parameters. Working scale depends on the real (i.e., natural) scale of the parameters. For 
non-circular distributions or for circular distributions with \code{estAngleMean}=FALSE:
}
\details{
1) if both lower and upper bounds are finite then logit is the working scale;
2) if lower bound is finite and upper bound is infinite then log is the working scale.

For circular distributions with \code{estAngleMean}=TRUE and no constraints imposed by a design matrix (DM) or bounds (userBounds), then the working parameters 
are complex functions of both the angle mean and concentrations/sd natural parameters (in this case, it's probably best just to focus on the real parameter
estimates!).  However, if constraints are imposed by DM or userBounds on circular distribution parameters with \code{estAngleMean}=TRUE and \code{circularAngleMean}=FALSE:

1) if the natural bounds are (-pi,pi] then tangent is the working scale, otherwise if both lower and upper bounds are finite then logit is the working scale;
2) if lower bound is finite and upper bound is infinite then log is the working scale.

When circular-circular regression is specified using \code{circularAngleMean}, the working scale 
for the mean turning angle is not as easily interpretable, but the 
link function is atan2(sin(X)*B,1+cos(X)*B), where X are the angle covariates and B the angle coefficients. 
Under this formulation, the reference turning angle is 0 (i.e., movement in the same direction as the previous time step). 
In other words, the mean turning angle is zero when the coefficient(s) B=0.
}
\examples{
# m is a momentuHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m

CIbeta(m)

}
