% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circAngles.R
\name{circAngles}
\alias{circAngles}
\title{Convert standard direction angles (in radians relative to the x-axis) to turning angle covariates suitable for circular-circular regression on the angle mean}
\usage{
circAngles(refAngle, data, coordNames = c("x", "y"))
}
\arguments{
\item{refAngle}{Numeric vector of standard direction angles (in radians) relative to the x-axis, where 0 = east, pi/2 = north, pi = west, -pi/2 = south}

\item{data}{data frame containing fields for the x- and y-coordinates (identified by \code{coordNames}) and 'ID' (if more than one individual)}

\item{coordNames}{Names of the columns of coordinates in \code{data}. Default: \code{c("x","y")}.}
}
\value{
A vector of turning angles between the movement direction at time step t-1 and \code{refAngle} at time t
}
\description{
This function can be used to convert angular covariates (e.g., ocean currents, wind direction) measured in radians relative to the x-axis to turning angle
covariates sutiable for circular-circular regression in \code{\link{fitHMM}} or \code{\link{MIfitHMM}}.
}
\examples{
# extract data from momentuHMM example
data<-example$m$data

# generate fake angle covariates
u <- rnorm(nrow(data)) # horizontal component
v <- rnorm(nrow(data)) # vertical component
refAngle <- atan2(v,u)

# add turning angle covariate to data
data$cov3 <- circAngles(refAngle=refAngle,data=data)

}
