% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hv.R
\name{hv_contributions}
\alias{hv_contributions}
\title{Hypervolume contribution of a set of points}
\usage{
hv_contributions(x, reference, maximise = FALSE)
}
\arguments{
\item{x}{\code{matrix()}|\code{data.frame()}\cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point.}

\item{reference}{\code{numeric()}\cr Reference point as a vector of numerical
values.}

\item{maximise}{\code{logical()}\cr Whether the objectives must be maximised
instead of minimised. Either a single logical value that applies to all
objectives or a vector of logical values, with one value per objective.}
}
\value{
\code{numeric()}\cr A numerical vector
}
\description{
Computes the hypervolume contribution of each point of a set of points with
respect to a given reference point.  The hypervolume contribution of point
\eqn{\vec{p} \in X} is \eqn{\text{hvc}(\vec{p}) = \text{hyp}(X) -
\text{hyp}(X \setminus \{\vec{p}\})}. Dominated points have zero
contribution but they may influence the contribution of other
points. Duplicated points have zero contribution even if not dominated,
because removing one of the duplicates does not change the hypervolume of
the remaining set.
}
\details{
The current implementation uses the \eqn{O(n\log n)} dimension-sweep
algorithm for 2D and the naive algorithm that requires calculating the
hypervolume \eqn{|X|+1} times for dimensions larger than 2.

For details about the hypervolume, see \code{\link[=hypervolume]{hypervolume()}}.
}
\examples{

x <- matrix(c(5,1, 1,5, 4,2, 4,4, 5,1), ncol=2, byrow=TRUE)
hv_contributions(x, reference=c(6,6))
# hvc[(5,1)] = 0 = duplicated
# hvc[(1,5)] = 3 = (4 - 1) * (6 - 5)
# hvc[(4,2)] = 2 = (5 - 4) * (4 - 2)
# hvc[(4,4)] = 0 = dominated
# hvc[(5,1)] = 0 = duplicated

data(SPEA2minstoptimeRichmond)
# The second objective must be maximized
# We calculate the hypervolume contribution of each point of the union of all sets.
hv_contributions(SPEA2minstoptimeRichmond[, 1:2], reference = c(250, 0),
            maximise = c(FALSE, TRUE))

# Duplicated points show zero contribution above, even if not
# dominated. However, filter_dominated removes all duplicates except
# one. Hence, there are more points below with nonzero contribution.
hv_contributions(filter_dominated(SPEA2minstoptimeRichmond[, 1:2], maximise = c(FALSE, TRUE)),
                 reference = c(250, 0), maximise = c(FALSE, TRUE))

}
\references{
\insertRef{FonPaqLop06:hypervolume}{moocore}

\insertRef{BeuFonLopPaqVah09:tec}{moocore}
}
\seealso{
\code{\link[=hypervolume]{hypervolume()}}
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
\concept{metrics}
