% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrgindata.R
\name{valid_data_set}
\alias{valid_data_set}
\alias{valid_data_set.matrix}
\title{Validate and prepare a data sets for simulation}
\usage{
valid_data_set(x, m = NULL, verbose = FALSE, quiet = FALSE)

valid_data_set.matrix(x, verbose = FALSE)
}
\arguments{
\item{x}{data.frame or matrix}

\item{m}{a model object}

\item{verbose}{logical}

\item{quiet}{if \code{TRUE}, messages will be suppressed}
}
\value{
A matrix with non-numeric columns dropped; if x is a 
data.frame with character \code{cmt} column comprised of valid 
compartment names and \code{m} is a model object,
the \code{cmt} column will be converted to the corresponding 
compartment number.
}
\description{
This function is called by mrgsim.  Users may also call this function
to pre-validate data when the same data set is used for repeated 
simulation.
}
\examples{

mod <- mrgsolve::house()

data(exTheoph)

d <- valid_data_set(exTheoph,mod)

}
\seealso{
\code{\link{valid_idata_set}}, \code{\link{idata_set}}, 
\code{\link{data_set}}
}
