% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{regress}
\alias{regress}
\title{Multi-output linear regression}
\usage{
regress(
  X,
  Y,
  preproc = NULL,
  method = c("lm", "enet", "mridge", "pls"),
  intercept = FALSE,
  lambda = 0.001,
  alpha = 0,
  ncomp = ceiling(ncol(X)/2),
  ...
)
}
\arguments{
\item{X}{the set of independent (basis) variables}

\item{Y}{the response matrix}

\item{preproc}{the pre-processor (currently unused)}

\item{method}{the regression method: \code{lm}, \code{enet}, \code{mridge}, or \code{pls}}

\item{intercept}{whether to include an intercept term}

\item{lambda}{ridge shrinkage parameter (for methods \code{mridge} and \code{enet})}

\item{alpha}{the elastic net mixing parameter if method is \code{enet}}

\item{ncomp}{number of PLS components if method is \code{pls}}

\item{...}{extra arguments sent to the underlying fitting function}
}
\value{
a bi-projector of type \code{regress}
}
\description{
Fit a multivariate regression model for a matrix of basis functions, \code{X}, and a response matrix \code{Y}.
The goal is to find a projection matrix that can be used for mapping and reconstruction.
}
\examples{
# Generate synthetic data
Y <- matrix(rnorm(100 * 10), 10, 100)
X <- matrix(rnorm(10 * 9), 10, 9)
# Fit regression models and reconstruct the response matrix
r_lm <- regress(X, Y, intercept = FALSE, method = "lm")
recon_lm <- reconstruct(r_lm)
r_mridge <- regress(X, Y, intercept = TRUE, method = "mridge", lambda = 0.001)
recon_mridge <- reconstruct(r_mridge)
r_enet <- regress(X, Y, intercept = TRUE, method = "enet", lambda = 0.001, alpha = 0.5)
recon_enet <- reconstruct(r_enet)
r_pls <- regress(X, Y, intercept = TRUE, method = "pls", ncomp = 5)
recon_pls <- reconstruct(r_pls)
}
