% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{cv}
\alias{cv}
\title{Cross-validation Framework}
\usage{
cv(x, folds, ...)
}
\arguments{
\item{x}{The object to perform cross-validation on (e.g., data matrix, formula, model object).}

\item{folds}{A list defining the cross-validation folds, typically containing \code{train} and \code{test} indices for each fold.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
The structure of the return value depends on the specific S3 method.
Typically, it will be an object containing the results of the cross-validation,
such as performance metrics per fold or aggregated metrics.
}
\description{
Generic function for performing cross-validation on various objects or data.
Specific methods should be implemented for different data types or model types.
}
\details{
The specific implementation details, default functions, and relevant arguments vary by method.

\strong{Bi-Projector Method (\code{cv.bi_projector}):}
Relevant arguments: \code{x}, \code{folds}, \code{max_comp}, \code{fit_fun},
\code{measure}, \code{measure_fun}, \code{return_models}, \code{...}.

This method performs cross-validation specifically for \code{bi_projector} models
(or models intended to be used like them, typically from unsupervised methods
like PCA or SVD). For each fold, it fits a single model using the training data
with the maximum number of components specified (\code{max_comp}). It then iterates
from 1 to \code{max_comp} components:
\enumerate{
\item It truncates the full model to \code{k} components using \code{truncate()}.
(Requires a \code{truncate} method for the fitted model class).
\item It reconstructs the held-out test data using the k-component truncated model
via \code{reconstruct_new()}.
\item It calculates reconstruction performance metrics (e.g., MSE, R2) by comparing
the original test data to the reconstruction using the \code{measure} argument
or a custom \code{measure_fun}.
}
The \code{fit_fun} must accept an argument \code{ncomp}. Additional arguments in \code{...}
are passed to \code{fit_fun} and \code{measure_fun}.

The return value is a \code{cv_fit} object (a list with class \code{cv_fit}), where the
\code{$results} element is a tibble. Each row corresponds to a fold, containing
the fold index (\code{fold}) and a nested tibble (\code{component_metrics}).
The \code{component_metrics} tibble has rows for each component evaluated (1 to
\code{max_comp}) and columns for the component index (\code{comp}) plus all
calculated metrics (e.g., \code{mse}, \code{r2}, \code{mae}) or error messages
(\code{comp_error}). If \code{return_models=TRUE}, the full model fitted on the training
data for each fold is included in a list column \code{model_full}.
}
\seealso{
\code{\link{cv_generic}}
}
\concept{cv}
