% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-cols.R
\name{add_miss_cluster}
\alias{add_miss_cluster}
\title{Add a column that tells us which "missingness cluster" a row belongs to}
\usage{
add_miss_cluster(data, cluster_method = "mcquitty", n_clusters = 2)
}
\arguments{
\item{data}{a dataframe}

\item{cluster_method}{character vector of the agglomeration method to use,
the default is "mcquitty". Options are taken from \code{stats::hclust}
helpfile, and options include: "ward.D", "ward.D2", "single", "complete",
"average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or
"centroid" (= UPGMC).}

\item{n_clusters}{numeric the number of clusters you expect. Defaults to 2.}
}
\description{
A way to extract the cluster of missingness that a group belongs to.
For example, if you use \code{vis_miss(airquality, cluster = TRUE)}, you can
see some clustering in the data, but you do not have a way to identify
the cluster. Future work will incorporate the \code{seriation} package to
allow for better control over the clustering from the user.
}
\examples{

add_miss_cluster(airquality)
add_miss_cluster(airquality, cluster_method = "ward.D")
add_miss_cluster(airquality, cluster_method = "ward.D", n_clusters = 3)
add_miss_cluster(airquality, n_clusters = 3)
}
\seealso{
\code{\link[=bind_shadow]{bind_shadow()}} \code{\link[=add_any_miss]{add_any_miss()}} \code{\link[=add_label_missings]{add_label_missings()}} \code{\link[=add_label_shadow]{add_label_shadow()}} \code{\link[=add_miss_cluster]{add_miss_cluster()}} \code{\link[=add_n_miss]{add_n_miss()}} \code{\link[=add_prop_miss]{add_prop_miss()}} \code{\link[=add_shadow_shift]{add_shadow_shift()}} \code{\link[=cast_shadow]{cast_shadow()}}
}
