% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{emr_track.addto}
\alias{emr_track.addto}
\title{Adds new records to a track}
\usage{
emr_track.addto(track, src, force = FALSE, remove_unknown = FALSE)
}
\arguments{
\item{track}{track name}

\item{src}{file name or data-frame containing the track records}

\item{force}{if 'TRUE', suppresses user confirmation for addition to
logical tracks}

\item{remove_unknown}{if 'TRUE', removes unknown ids (ids that are not present at 'patients.dob' track) from the data. Otherwise, an error is thrown.}
}
\value{
None.
}
\description{
Adds new records to a track from a TAB-delimited file or a data frame.
}
\details{
This function adds new records to a track. The records are contained either
in a file or a data frame.

If 'src' is a file name, the latter must be constituted of four columns
separated by spaces or 'TAB' characters: ID, time, reference and value. The
file might contain lines of comments which should start with a '#'
character. Note that the file should not contain a header line.

Alternatively 'src' can be a data frame consisting of the columns named
"id", "time", "ref" and "value". Note: "ref" column in the data frame is
optional.

Adding to a logical track adds the values to the underlying physical
track, and is allowed only if all the values are within the logical
track allowed values and only from a data frame \code{src}. Note that
this might affect other logical tracks pointing to the same physical
track and therefore requires confirmation from the user unless
\code{force=TRUE}.
}
\seealso{
\code{\link{emr_track.import}}, \code{\link{emr_track.create}},
\code{\link{emr_db.init}}, \code{\link{emr_track.ls}}
}
\keyword{~import}
