% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_speleothems.R
\name{get_speleothems}
\alias{get_speleothems}
\alias{get_speleothems.numeric}
\alias{get_speleothems.sites}
\title{get_speleothems}
\usage{
get_speleothems(x = NA, ...)

\method{get_speleothems}{numeric}(x, ...)

\method{get_speleothems}{sites}(x, ...)
}
\arguments{
\item{x}{A dataset ID or vector of dataset IDs}

\item{...}{accepted arguments}
}
\value{
\code{sites} object with speleothem data
}
\description{
get_speleothems
}
\details{
Experimental function: API and behavior may change.
The \code{get_speleothems()} command wraps the Neotoma API
(\href{https://api.neotomadb.org}{api.neotomadb.org}) call for \code{speleothems}.
The call itself uses a SQL query which accepts any one of the following
parameters:
\itemize{
\item \code{x}  The unique dataset ID (integer) in Neotoma. Can be passed as a
vector of dataset IDs.
\item \code{sites}  A \code{sites} R object.
}
}
\examples{
{
## Find speleothems by numeric datasetid:
tryCatch({
  speleo <- get_speleothems(c(2,5))
}, error = function(e) {
  message("Neotoma server not responding. Try again later.")
})
}
}
\author{
Socorro Dominguez \email{dominguezvid@wisc.edu}
}
