% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_genericDefinitions.R, R/collunits-methods.R
\name{add_chronology}
\alias{add_chronology}
\alias{add_chronology,collunit,chronology,data.frame-method}
\alias{add_chronology,collunit-method}
\title{Add a new chronology into an existing collectionunit.}
\usage{
add_chronology(object, x, y)

\S4method{add_chronology}{collunit,chronology,data.frame}(object, x, y)
}
\arguments{
\item{object}{A collection unit object}

\item{x}{A chronology object generated using \code{set_chronology()}}

\item{y}{A data.frame of sample ages, with required columns:
\code{"analysisunitid"}, \code{"age"}, \code{"agetype"}, \code{"ageolder"}, and \code{"ageyounger"}.}
}
\value{
\code{chronologies} with new added chronology
}
\description{
Given a collunit, add a new chronology object to the unit
with both the chronology metadata and the age information (as \code{y})
}
\details{
When undertaking analysis we may wish to add a new chronology to
existing records within Neotoma. To do this we must first build the
chronology, but also link it to existing analysis units within the
collection unit.
For examples from this function, see the
https://open.neotomadb.org/EPD_binder/complex_workflow.html
documentation online.
}
\author{
Socorro Dominguez \email{dominguezvid@wisc.edu}
}
