% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{build_layout_cpp}
\alias{build_layout_cpp}
\title{Entry point for R to generate coral plot data from a set of association rules.}
\usage{
build_layout_cpp(parsed, grid_size, lhs_sort = "confidence")
}
\arguments{
\item{parsed}{A list as returned by `parse_rules()`, with components:
\itemize{
  \item \code{items}: \code{data.frame} with at least
    \code{item_id} (integer, 0-based) and \code{label} (character).
  \item \code{rules}: \code{data.frame} with at least
    \code{rule_id} (integer), \code{support}, \code{confidence}, \code{lift}
    (numeric), and list-columns \code{lhs_item_ids}, \code{rhs_item_ids}
    containing 0-based integer vectors.
}}

\item{grid_size}{Integer; number of grid cells per layout side used to place
corals on a near-square grid (e.g., 3 means a 3×3 canvas)}

\item{lhs_sort}{Character; metric used to sort antecedent items within each
LHS path when building the layout. One of \code{"confidence"},
\code{"support"}, \code{"lift"} (default \code{"confidence"}). Sorting is
applied in descending order of the chosen metric.}
}
\value{
A List containing two DataFrames:
\itemize{
   \item \code{edges}: DataFrame with start and end coordinates, line width, and color for each edge.
   \item \code{nodes}: DataFrame with position, radius, ID, and item label for each node.
}
}
\description{
This function takes a list of parsed association rules and produces two data frames:
one for the nodes and one for the edges of a coral plot. It acts as a wrapper that:
\itemize{
   \item Constructs the coral layout.
   \item Converts the resulting nodes and edges into R-compatible data frames.
}
}
\keyword{internal}
