% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nchains.R
\name{nchains}
\alias{nchains}
\alias{nchains.nlist}
\alias{nchains.nlists}
\title{Number of MCMC chains}
\usage{
nchains(x, ...)

\method{nchains}{nlist}(x, ...)

\method{nchains}{nlists}(x, ...)
}
\arguments{
\item{x}{An MCMC object}

\item{...}{Unused}
}
\value{
A count indicating the number of MCMC chains
}
\description{
Gets the number of chains of an MCMC object.
}
\section{Methods (by class)}{
\itemize{
\item \code{nlist}: Number of chains of an \code{\link[nlist:nlist_object]{nlist::nlist_object()}}

Always 1L.

\item \code{nlists}: Number of chains of an \code{\link[nlist:nlists_object]{nlist::nlists_object()}}
}}

\examples{
nchains(nlist(x = 1:2))
nchains(nlists(nlist(x = c(2, 9)), nlist(x = c(1, 7))))
nchains(split_chains(nlists(nlist(x = c(2, 9)), nlist(x = c(1, 7)))))
}
