% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niters.R
\name{niters}
\alias{niters}
\alias{niters.nlist}
\alias{niters.nlists}
\title{Number of MCMC Iterations}
\usage{
niters(x, ...)

\method{niters}{nlist}(x, ...)

\method{niters}{nlists}(x, ...)
}
\arguments{
\item{x}{The object}

\item{...}{Unused.}
}
\value{
A count indicating the number of MCMC iterations.
}
\description{
Gets the number of MCMC iterations (in a chain).
}
\section{Methods (by class)}{
\itemize{
\item \code{nlist}: Number of MCMC iterations for an nlist object

Always 1.

\item \code{nlists}: Number of MCMC iterations for an nlists object
}}

\examples{
niters(nlist(x = 1:2))
niters(nlists(nlist(x = c(2, 9)), nlist(x = c(1, 7))))
}
