% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{binApply1D}
\alias{binApply1D}
\title{Apply a function to vector data}
\usage{
binApply1D(x, f, xbreaks, FUN, ...)
}
\arguments{
\item{x}{a vector of numerical values.}

\item{f}{a vector of data to which the elements of \code{FUN} may be
supplied}

\item{xbreaks}{values of x at the boundaries between bins; calculated using
\code{\link[=pretty]{pretty()}} if not supplied.}

\item{FUN}{function to apply to the data}

\item{\dots}{arguments to pass to the function \code{FUN}}
}
\value{
A list with the following elements: the breaks in x and y
(\code{xbreaks} and \code{ybreaks}), the break mid-points (\code{xmids} and
\code{ymids}), and a matrix containing the result of applying function
\code{FUN} to \code{f} subsetted by these breaks.
}
\description{
The function \code{FUN} is applied to \code{f} in bins specified by
\code{xbreaks}.  (If \code{FUN} is \code{\link[=mean]{mean()}},
consider using \code{\link[=binMean2D]{binMean2D()}} instead, since it should be faster.)
}
\examples{
library(oce)
## salinity profile with median and quartile 1 and 3
data(ctd)
p <- ctd[["pressure"]]
S <- ctd[["salinity"]]
q1 <- binApply1D(p, S, pretty(p, 30), function(x) quantile(x, 1/4))
q3 <- binApply1D(p, S, pretty(p, 30), function(x) quantile(x, 3/4))
plotProfile(ctd, "salinity", col='gray', type='n')
polygon(c(q1$result, rev(q3$result)),
c(q1$xmids, rev(q1$xmids)), col='gray')
points(S, p, pch=20)

}
\seealso{
Other bin-related functions: 
\code{\link{binApply2D}()},
\code{\link{binAverage}()},
\code{\link{binCount1D}()},
\code{\link{binCount2D}()},
\code{\link{binMean1D}()},
\code{\link{binMean2D}()}
}
\author{
Dan Kelley
}
\concept{bin-related functions}
