% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{[[,ctd-method}
\alias{[[,ctd-method}
\title{Extract Something From a ctd Object}
\usage{
\S4method{[[}{ctd}(x, i, j, ...)
}
\arguments{
\item{x}{a \linkS4class{ctd} object.}

\item{i}{character value indicating the name of an item to extract.}

\item{j}{optional additional information on the \code{i} item.}

\item{...}{ignored.}
}
\description{
Generally, the \code{[[} method lets users extract information from \code{oce}
objects, without having to know the details of the internal storage.  For
many \code{oce} sub-classes, \code{[[} can also return quantities that are computed
from the object's contents.
}
\details{
A two-step process is used to try to find the requested information. First, a
class-specific function is used (see \dQuote{Details of the Specialized
Method}).  If this yields nothing, then a general method is used (see
\dQuote{Details of the General Method}).  If both methods fail, then \code{[[}
returns NULL.

Some understanding of the subclass is required to know what can be retrieved
with \code{[[}. When dealing with an unfamiliar subclass, it can be useful to
first use \code{x[["?"]]} to get a listing of the retrievable items. See
\dQuote{Details of the Specialized Method} for more information.
}
\section{Details of the Specialized Method}{


Some uses of \code{\link{[[,ctd-method}} involve direct retrieval of
items within the \code{data} slot of the \code{ctd} object,
while other uses involve calculations based on items in that
\code{data} slot. For example, all \code{ctd} objects
should hold an item named \code{temperature} in the \code{data}
slot, so for example \code{x[["temperature"]]} will retrieve that
item. By contrast, \code{x[["sigmaTheta"]]} is taken to be a
request to compute \eqn{\sigma_\theta}{sigma[theta]}, and so
it yields a call to \link{swTheta}\code{(x)} even if
the \code{data} slot of \code{x} might happen to contain an item
named \code{theta}. This can be confusing at first, but it tends
to lead to fewer surprises in everyday work, for otherwise the
user would be forced to check the contents of any \code{ctd}
object under analysis, to determine whether that item will be looked
up or computed. Nothing is lost in this scheme, since the data
within the object are always accessible with \code{\link[=oceGetData]{oceGetData()}}.

It should be noted that the accessor is set up to retrieve quantities
in conventional units. For example, \code{\link[=read.ctd.sbe]{read.ctd.sbe()}} is
used on a \code{.cnv} file that stores pressure in psi, it will
be stored in the same unit within the \code{ctd} object, but
\code{x[["pressure"]]} will return a value that has been converted
to decibars.  (To get pressure in PSI, use \code{x[["pressurePSI"]]}.)
Similarly, temperature is
returned in the ITS-90 scale, with a conversion having been performed with
\code{\link[=T90fromT68]{T90fromT68()}}, if the object holds temperature in
IPTS-68.  Again, temperature on the IPTS-68
scale is returned with \code{x@data$temperature}.

This preference for computed over stored quantities is accomplished
by first checking for computed quantities, and then falling
back to the general \code{[[} method if no match is found.

Some quantities are optionally computed. For example, some data files
(e.g. the one upon which the \code{\link[=section]{section()}} dataset is based)
store \code{nitrite} along with the sum of nitrite and nitrate, the
latter with name \code{NO2+NO3}. In this case, e.g. \code{x[["nitrate"]]}
will detect the setup, and subtract nitrite from the sum to yield
nitrate.

The list given below provides notes on some quantities that are
available using e.g. \code{ctd[[i]]}.
\itemize{
\item If \code{i} is \code{"?"}, then the return value is a list
containing four items, each of which is a character vector
holding the names of things that can be accessed with \code{[[}.
The \code{data} and \code{metadata} items hold the names of
entries in the object's data and metadata
slots, respectively. The \code{dataDerived}
and \code{metadataDerived} items hold the names of things
that can be inferred from the object's contents, e.g.
\code{"SA"} is named in \code{dataDerived}, indicating that
\code{argo[["SA"]]} is permitted (to compute Absolute Salinity).
\item If \code{i} is \code{"conductivity"} without a second argument (e.g. \code{a[["conductivity"]]})
then the return value is the seawater electrical conductivity (if available
or computable). However, if a second argument is given,
and it is string specifying a unit, then conversion is made to that unit. The
permitted units are: either \code{""} or \code{"ratio"} (for ratio),
\code{"uS/cm"}, \code{"mS/cm"} and \code{"S/m"}. The calculations are based on
the definition of conductivity ratio as the ratio between measured conductivity
and the standard value 4.2914 S/m.
\item If \code{i} is \code{"CT"} or \code{"Conservative Temperature"} then Conservative
Temperature, computed with \code{\link[gsw:gsw_CT_from_t]{gsw::gsw_CT_from_t()}}, is returned.
\item If \code{i} is \code{"density"} then seawater density, computed with \link{swRho}\code{(x)},
is returned. (Note that it may be better to call that function directly, to gain
control of the choice of equation of state, etc.)
\item If \code{i} is \code{"depth"} then the depth in metres below the surface, computed
with \link{swDepth}\code{(x)}, is returned.
\item If \code{i} is \code{"N2"} then the square of Brunt-Vaisala frequency, computed  with
\link{swN2}\code{(x)}, is returned.
\item If \code{i} is \code{"potential temperature"} or \code{"theta"}, then potential temperature in the
UNESCO formulation, computed with \link{swTheta}\code{(x)}, is returned.
\item If \code{i} is \code{"Rrho"} then density ratio, computed with \link{swRrho}\code{(x)}, is
returned.
\item If \code{i} is \code{"SA"} or \code{"Absolute Salinity"} then Absolute Salinity,
computed with \code{\link[gsw:gsw_SA_from_SP]{gsw::gsw_SA_from_SP()}}, is returned.
The calculation involves location as well as measured water properties.
If the object \code{x} does not containing information on the location,
then 30N and 60W is used for the calculation, and a warning is generated.
\item If \code{i} is \code{"sigmaTheta"} then a form of potential density anomaly, computed with
\link{swSigmaTheta}\code{(x)}, is returned.
\item If \code{i} is \code{"sigma0"} then potential density anomaly
referenced to a sea pressure of 0dbar (the surface), computed with \link{swSigma0}\code{(x)},
is returned.
\item If \code{i} is \code{"sigma2"} then potential density anomaly
referenced to a sea pressure of 1000dbar, computed with \link{swSigma1}\code{(x)},
is returned.
\item If \code{i} is \code{"sigma2"} then potential density anomaly
referenced to a sea pressure of 2000dbar, computed with \link{swSigma2}\code{(x)},
is returned.
\item If \code{i} is \code{"sigma3"} then potential density anomaly
referenced to a sea pressure of 3000dbar, computed with \link{swSigma3}\code{(x)},
is returned.
\item If \code{i} is \code{"sigma4"} then potential density anomaly
referenced to a sea pressure of 4000dbar, computed with \link{swSigma4}\code{(x)},
is returned.
\item If \code{i} is \code{"SP"} then salinity on the Practical Salinity Scale, which is
\code{salinity} in the \code{data} slot, is returned.
\item If \code{i} is \code{"spice"} or \code{"spiciness0"} then a variable that is in some sense
orthogonal to density, calculated with \link{swSpice}\code{(x)}, is returned.
Note that this is defined differently for \code{eos="unesco"} and
\code{eos="gsw"}.
\item If \code{i} is \code{"SR"} then Reference Salinity, computed with
\code{\link[gsw:gsw_SR_from_SP]{gsw::gsw_SR_from_SP()}}, is returned.
\item If \code{i} is \code{"Sstar"} then Preformed Salinity, computed with
\code{\link[gsw:gsw_SR_from_SP]{gsw::gsw_SR_from_SP()}}, is returned.
See \code{SA} for a note on longitude and latitude.
\item If \code{i} is \code{"time"} then either vector of times or a single
time, is returned, if available. A vector is returned if \code{time}
is present in the \code{data} slot, or if a time can be
inferred from other entries in the \code{data} slot (some of which,
such as the common \code{timeS}, also employ
\code{startTime} within the \code{metadata} slot). A single
value is returned if the dataset only has information on the start
time (which is stored as \code{startTime} within the \code{metadata}
slot. If it is impossible to determine the sampling time, then
\code{NULL} is returned. These time variants occur, in the
present version of oce, only for data read by \code{\link[=read.ctd.sbe]{read.ctd.sbe()}},
the documentation of which explains how times are computed.
\item If \code{i} is \code{"z"} then vertical coordinate in metres
above the surface, computed with \link{swZ}\code{(x)}, is returned.
}
}

\section{Details of the General Method}{


Note: the text of this section is identical for all \code{oce} subclasses, and so
some of what you read here may not be relevant to the class being described
in this help page.

If the specialized method produces no matches, the following generalized
method is applied. As with the specialized method, the procedure hinges first
on the values of \code{i} and, optionally, \code{j}. The work proceeds in steps, by
testing a sequence of possible conditions in sequence.
\enumerate{
\item A check is made as to whether \code{i} names one of the standard \code{oce} slots.
If so, \code{[[} returns the slot contents of that slot.  Thus, \code{x[["metadata"]]}
will retrieve the \code{metadata} slot, while \code{x[["data"]]} and
\code{x[["processingLog"]]} return those slots.
\item If \code{i} is a string ending in the \code{"Unit"}, then the characters preceding
that string are taken to be the name of an item in the data object, and a
list containing the unit is returned (or \code{NULL} if there is no such unit).
This list consists of an item named \code{unit}, which is an \code{\link[=expression]{expression()}}, and
an item named \code{scale}, which is a string describing the measurement scale.
If the string ends in \code{" unit"}, e.g.  \code{x[["temperature unit"]]} (note the
space), then just the expression is returned, and if it ends in \code{" scale"},
then just the scale is returned.
\item If \code{i} is a string ending in \code{"Flag"}, then the corresponding data-quality
flag is returned (or \code{NULL} if there is no such flag).
\item If the object holds hydrographic information (pressure, salinity,
temperature, longitude and latitude) then another set of possibilities
arises.  If \code{i} is \code{"sigmaTheta"}, then the value of \code{\link[=swSigmaTheta]{swSigmaTheta()}} is
called with \code{x} as the sole argument, and the results are returned.
Similarly, \code{\link[=swSigma0]{swSigma0()}} is used if \code{i="sigma0"}, and \code{\link[=swSpice]{swSpice()}} is used if
\code{i="spice"}. Of course, these actions only make sense for objects that
contain the relevant items within their \code{data} slot.
\item After these possibilities are eliminated, the action depends on whether
\code{j} has been provided.  If \code{j} is not provided, or is the string \code{""}, then
\code{i} is sought in the \code{metadata} slot, and then in the \code{data} slot, returning
whichever is found first.  In other words, if \code{j} is not provided, the
\code{metadata} slot takes preference over the \code{data} slot. However, if \code{j} is
provided, then it must be either the string \code{"metadata"} or \code{"data"}, and it
directs where to look.
\item If none of the above-listed conditions holds, then \code{NULL} is returned.
}
}

\examples{
data(ctd)
head(ctd[["temperature"]])

}
\seealso{
Other functions that extract parts of oce objects: 
\code{\link{[[,adp-method}},
\code{\link{[[,adv-method}},
\code{\link{[[,amsr-method}},
\code{\link{[[,argo-method}},
\code{\link{[[,bremen-method}},
\code{\link{[[,cm-method}},
\code{\link{[[,coastline-method}},
\code{\link{[[,echosounder-method}},
\code{\link{[[,g1sst-method}},
\code{\link{[[,gps-method}},
\code{\link{[[,ladp-method}},
\code{\link{[[,landsat-method}},
\code{\link{[[,lisst-method}},
\code{\link{[[,lobo-method}},
\code{\link{[[,met-method}},
\code{\link{[[,oce-method}},
\code{\link{[[,odf-method}},
\code{\link{[[,rsk-method}},
\code{\link{[[,sealevel-method}},
\code{\link{[[,section-method}},
\code{\link{[[,tidem-method}},
\code{\link{[[,topo-method}},
\code{\link{[[,windrose-method}},
\code{\link{[[,xbt-method}},
\code{\link{[[<-,adv-method}}

Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv}},
\code{\link{ctd}},
\code{\link{d200321-001.ctd}},
\code{\link{d201211_0011.cnv}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.ssda}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}
}
\author{
Dan Kelley
}
\concept{functions that extract parts of oce objects}
\concept{things related to ctd data}
