% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_properties.R
\name{fp_text}
\alias{fp_text}
\alias{fp_text_lite}
\alias{format.fp_text}
\alias{print.fp_text}
\alias{update.fp_text}
\title{Text formatting properties}
\usage{
fp_text(
  color = "black",
  font.size = 10,
  bold = FALSE,
  italic = FALSE,
  underlined = FALSE,
  font.family = "Arial",
  cs.family = NULL,
  eastasia.family = NULL,
  hansi.family = NULL,
  vertical.align = "baseline",
  shading.color = "transparent"
)

fp_text_lite(
  color = NA,
  font.size = NA,
  font.family = NA,
  cs.family = NA,
  eastasia.family = NA,
  hansi.family = NA,
  bold = NA,
  italic = NA,
  underlined = NA,
  vertical.align = "baseline",
  shading.color = NA
)

\method{format}{fp_text}(x, type = "wml", ...)

\method{print}{fp_text}(x, ...)

\method{update}{fp_text}(
  object,
  color,
  font.size,
  bold,
  italic,
  underlined,
  font.family,
  cs.family,
  eastasia.family,
  hansi.family,
  vertical.align,
  shading.color,
  ...
)
}
\arguments{
\item{color}{font color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{font.size}{font size (in point) - 0 or positive integer value.}

\item{bold}{is bold}

\item{italic}{is italic}

\item{underlined}{is underlined}

\item{font.family}{single character value. Specifies the font to
be used to format characters in the Unicode range (U+0000-U+007F).}

\item{cs.family}{optional font to be used to format
characters in a complex script Unicode range. For example, Arabic
text might be displayed using the "Arial Unicode MS" font.}

\item{eastasia.family}{optional font to be used to
format characters in an East Asian Unicode range. For example,
Japanese text might be displayed using the "MS Mincho" font.}

\item{hansi.family}{optional. Specifies the font to be used to format
characters in a Unicode range which does not fall into one of the
other categories.}

\item{vertical.align}{single character value specifying font vertical alignments.
Expected value is one of the following : default \code{'baseline'}
or \code{'subscript'} or \code{'superscript'}}

\item{shading.color}{shading color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{x}{\code{fp_text} object}

\item{type}{output type - one of 'wml', 'pml', 'html', 'rtf'.}

\item{...}{further arguments - not used}

\item{object}{\code{fp_text} object to modify}

\item{format}{format type, wml for MS word, pml for
MS PowerPoint and html.}
}
\value{
a \code{fp_text} object
}
\description{
Create an \code{fp_text} object that describes
text formatting properties.

Function \code{fp_text_lite()} is generating properties
with only entries for the parameters users provided. The
undefined properties will inherit from the default settings.
}
\examples{
fp_text()
fp_text(color = "red")
fp_text(bold = TRUE, shading.color = "yellow")
print(fp_text(color = "red", font.size = 12))
}
\seealso{
\code{\link[=ftext]{ftext()}}, \code{\link[=fpar]{fpar()}}

Other functions for defining formatting properties: 
\code{\link{fp_border}()},
\code{\link{fp_cell}()},
\code{\link{fp_par}()},
\code{\link{fp_tab}()},
\code{\link{fp_tabs}()}
}
\concept{functions for defining formatting properties}
