% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_sim_to_profile_p}
\alias{get_sim_to_profile_p}
\title{Get p-value for best-match-average similarity between two term sets}
\usage{
get_sim_to_profile_p(term_sim_mat, profile, term_set,
  sample_from = colnames(term_sim_mat), min_its = 1000, max_its = 1e+05,
  signif = 0.05, log_dismiss = -10)
}
\arguments{
\item{term_sim_mat}{Numeric matrix with rows and columns corresponding to (and named by) term IDs, and cells containing the similarity between the row and column term}

\item{profile}{Character vector of ontological term IDs}

\item{term_set}{Character vector of ontological term IDs}

\item{sample_from}{Character vector of ontological term IDs to sample term sets from}

\item{min_its}{Minimum number of simulated group similarities to calculate}

\item{max_its}{Maximum number of simulated group similarities to calculate}

\item{signif}{Threshold p-value of statistical significance}

\item{log_dismiss}{Threshold of log probability, below which to trigger return of current estimated p-value}
}
\value{
Numeric p-value
}
\description{
Get p-value by comparison of similarity of \code{profile} and \code{term_set} to distribution of similarities obtained by simulating random term sets (i.e. comprising random sets of terms the same size as \code{term_set}) and calculating the similarity to \code{profile}.
}

