% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_mw.R
\name{set_mw<-}
\alias{set_mw<-}
\alias{set_mw<-,Multiwave-method}
\title{Write Slots of a Multiwave Object}
\usage{
set_mw(
  x,
  phase = 1,
  wave = NA,
  slot = c("data", "design", "metadata", "samples", "sampled_data")
) <- value
}
\arguments{
\item{x}{an object of class \code{'Multiwave'}}

\item{phase}{a numeric value specifying the phase that should be accessed.
To access the overall metadata, set \code{phase = NA}. Defaults to 1.}

\item{wave}{a numeric value specifying the wave that should be accessed.
Ta access phase metadata, set \code{wave = NA}. Defaults to \code{NA}.}

\item{slot}{a character value specifying the name of the slot to be
accessed. Must be one of \code{"metadata"}, \code{"design"},
\code{"samples"}, \code{"sampled_data"}, \code{"data"}. Defaults to
\code{"data"}. See class documentation or package vignettes for more
information about slots.}

\item{value}{value to assign to specified slot}
}
\description{
\code{set_mw} is used to assign values (write to) slots of
\code{Multiwave} class objects. It is used to set values of
multiwave (mw) objects.
}
\examples{
# Intiate multiwave object
MySurvey <- multiwave(phases = 2, waves = c(1, 3))

# To write overall metadata
set_mw(MySurvey, phase = NA, slot = "metadata") <-
 list(title = "Maternal Weight Survey")

# To write Phase 2 metadata
set_mw(MySurvey, phase = 2, slot = "metadata") <-
 list(strata = "mystrata", id = "id")

}
