% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_t1d_diagnoses_cols}
\alias{add_t1d_diagnoses_cols}
\title{Add columns related to type 1 diabetes diagnoses}
\usage{
add_t1d_diagnoses_cols(data)
}
\arguments{
\item{data}{Data from \code{\link[=keep_diabetes_diagnoses]{keep_diabetes_diagnoses()}} function.}
}
\value{
The same type as the input data, as a \code{\link[duckplyr:duckdb_tibble]{duckplyr::duckdb_tibble()}},
with the following added columns and up to two rows per individual:
\itemize{
\item \code{has_majority_t1d_diagnoses}: A logical vector indicating whether the
majority of primary diagnoses are related to type 1 diabetes.
\item \code{has_any_t1d_primary_diagnosis}: A logical vector indicating whether
there is at least one primary diagnosis related to type 1 diabetes.
}
}
\description{
This function evaluates whether an individual has a majority of type 1
diabetes-specific hospital diagnoses (DE10) among all type-specific diabetes
primary diagnoses (DE10 & DE11) from endocrinology departments. If an individual
doesn't have any type-specific diabetes diagnoses from endocrinology departments,
the majority is determined by diagnoses from medical departments.

It also adds a column indicating whether an individual has at least one
primary diagnosis related to type 1 diabetes.

This output is passed to the \code{\link[=join_inclusions]{join_inclusions()}} function, where the
\code{dates} variable is used for the final step of the inclusion process.
The variables for whether the majority of diagnoses are for type 1 diabetes
is used for later classification of type 1 diabetes.
}
\seealso{
See the \code{vignette("algorithm")} for the logic used to filter these
patients.
}
\keyword{internal}
