% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_changesets.R
\name{osm_create_changeset}
\alias{osm_create_changeset}
\alias{osm_update_changeset}
\alias{osm_close_changeset}
\title{Create, update, or close a changeset}
\usage{
osm_create_changeset(
  comment,
  ...,
  created_by = paste("osmapiR", getOption("osmapir.osmapir_version")),
  verbose = FALSE
)

osm_update_changeset(
  changeset_id,
  comment,
  ...,
  created_by = paste("osmapiR", getOption("osmapir.osmapir_version")),
  verbose = FALSE
)

osm_close_changeset(changeset_id)
}
\arguments{
\item{comment}{Tag comment is mandatory.}

\item{...}{Arbitrary tags to add to the changeset as named parameters (key = "value").}

\item{created_by}{Tag with the client data. By default, \verb{osmapiR x.y.z}.}

\item{verbose}{If \code{TRUE}, print the tags of the new changeset.}

\item{changeset_id}{The id of the changeset to update. The user issuing this API call has to be the same that created
the changeset.}
}
\value{
The ID of the newly created changeset or a \code{data.frame} inheriting \code{osmapi_changesets} with the details of
the updated changeset.

Nothing is returned upon successful closing of a changeset.
}
\description{
Create, update, or close a changeset
}
\details{
See \url{https://wiki.openstreetmap.org/wiki/Changeset} for details and the most common changeset's tags.

When updating a changeset, unchanged tags have to be repeated in order to not be deleted.
}
\section{Functions}{
\itemize{
\item \code{osm_create_changeset()}: Open a new changeset for editing.

\item \code{osm_update_changeset()}: Update the tags of an open changeset.

\item \code{osm_close_changeset()}: Close a changeset. A changeset may already have been closed without the owner
issuing this API call. In this case an error code is returned.

}}
\examples{
\dontrun{
set_osmapi_connection("testing") # use the testing server

chset_id <- osm_create_changeset(
  comment = "Describe the changeset",
  source = "GPS;survey",
  hashtags = "#testing;#osmapiR"
)

chaset <- osm_read_changeset(changeset_id = chset_id)
chaset

upd_chaset <- osm_update_changeset(
  changeset_id = chset_id,
  comment = "Improved description of the changeset",
  hashtags = "#testing;#osmapiR"
)
upd_chaset
}
}
\seealso{
Other edit changeset's functions: 
\code{\link{osm_diff_upload_changeset}()}
}
\concept{edit changeset's functions}
