% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studyLocus2GeneTable.R
\name{studyLocus2GeneTable}
\alias{studyLocus2GeneTable}
\title{Retrieve the locus-to-gene (L2G) data table for loci genes.}
\usage{
studyLocus2GeneTable(study_id, variant_id)
}
\arguments{
\item{study_id}{Character: Study ID(s) generated by Open Targets Genetics (e.g GCST90002357).}

\item{variant_id}{Character: generated ID for variants by Open Targets Genetics (e.g. 1_154119580_C_A) or rsId (rs2494663).}
}
\value{
Returns a data frame with the summary statistics of the study and a data table containing various
calculated scores and features for any lead variant. The output table has the following data structure:

\itemize{
  \item{\code{studyId}:} \emph{Character}. Study ID.
  \item{\code{variant.id}:} \emph{Character}. Variant ID.
  \item{\code{variant.rsId}:} \emph{Character}. Variant rsID.
  \item{\code{yProbaDistance}:} \emph{Numeric}. Distance score.
  \item{\code{yProbaModel}:} \emph{Numeric}. Model score.
  \item{\code{yProbaMolecularQTL}:} \emph{Numeric}. Molecular QTL score.
  \item{\code{yProbaPathogenicity}:} \emph{Numeric}. Pathogenicity score.
  \item{\code{yProbaInteraction}:} \emph{Numeric}. Interaction score.
  \item{\code{hasColoc}:} \emph{Logical}. Indicates if colocalization data is available.
  \item{\code{distanceToLocus}:} \emph{Numeric}. Distance to the locus.
  \item{\code{gene.id}:} \emph{Character}. Gene ID.
  \item{\code{gene.symbol}:} \emph{Character}. Gene symbol.
}
}
\description{
This function fetches the locus-to-gene (L2G) pipeline summary data table for
the neighboring genes of a variant in a GWAS study.
}
\examples{
\dontrun{
result <- studyLocus2GeneTable(study_id = "GCST90002357", variant_id = "1_154119580_C_A")
result <- studyLocus2GeneTable(study_id = "GCST90002357", variant_id = "rs2494663")
}
}
