% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{multijitter}
\alias{multijitter}
\title{Wrapper around jitterp that plots multiple jitter plots on the same plotting device (analogous to violins())}
\usage{
multijitter(
  x,
  data = NULL,
  group = NULL,
  horiz = FALSE,
  order = NULL,
  xlab = "",
  ylab = "",
  col = "black",
  pch = 16,
  spaces = "_",
  width = 0.1,
  xlim = NULL,
  ylim = NULL,
  add = TRUE,
  ax = FALSE,
  srt = 45,
  ...
)
}
\arguments{
\item{x}{plotting statistic (numeric vector) or formula object from which a plotting statistic and grouping variable can be extracter (i.e. of form x~group)}

\item{data}{data.frame object containing x and y}

\item{group}{grouping variable}

\item{horiz}{logical indicating whether to plot horizontally}

\item{order}{order of factor levels of categorical factor}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{col}{vector of border colors}

\item{pch}{vector of symbols}

\item{spaces}{character string in group to replace with spaces for labels, if not NULL}

\item{width}{standard deviation for jitter}

\item{xlim}{x limits (data limits used if NULL)}

\item{ylim}{y limits (data limits used if NULL)}

\item{add}{logical whether to add to existing plot (default: TRUE)}

\item{ax}{whether to plot axes}

\item{srt}{angle for categorical axis text rotation}

\item{...}{other arguments to pass on to jitterp() and plot()}
}
\description{
Wrapper around jitterp that plots multiple jitter plots on the same plotting device (analogous to violins())
}
\examples{
data.frame(p=rnorm(50), cat=rep(c("A","B","B","B","B"),10))->d
multijitter(p~cat,d, add=FALSE)
}
